/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.screen.components.ActiveBasedTextureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class KeycardReaderScreen
extends AbstractContainerScreen<KeycardReaderMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/keycard_reader.png");
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation RANDOM_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random.png");
    private static final ResourceLocation RANDOM_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random_inactive.png");
    private static final ResourceLocation RESET_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset.png");
    private static final ResourceLocation RESET_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset_inactive.png");
    private static final ResourceLocation RETURN_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return.png");
    private static final ResourceLocation RETURN_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return_inactive.png");
    private static final ResourceLocation WORLD_SELECTION_ICONS = new ResourceLocation("textures/gui/world_selection.png");
    private static final Component EQUALS = Component.m_237113_((String)"=");
    private static final Component GREATER_THAN_EQUALS = Component.m_237113_((String)">=");
    private static final int MAX_SIGNATURE = 99999;
    private final Component signatureText = Utils.localize("gui.securitycraft:keycard_reader.signature", new Object[0]);
    private final Component keycardLevelsText = Utils.localize("gui.securitycraft:keycard_reader.keycard_levels", new Object[0]);
    private final Component linkText = Utils.localize("gui.securitycraft:keycard_reader.link", new Object[0]);
    private final Component levelMismatchInfo = Utils.localize("gui.securitycraft:keycard_reader.level_mismatch", new Object[0]);
    private final Component limitedInfo = Utils.localize("tooltip.securitycraft:keycard.limited_info", new Object[0]);
    private Component smartModuleTooltip;
    private final KeycardReaderBlockEntity be;
    private final boolean hasSmartModule;
    private final boolean isOwner;
    private boolean isExactLevel = true;
    private int previousSignature;
    private int signature;
    private boolean[] acceptedLevels;
    private int signatureTextLength;
    private int signatureTextStartX;
    private Button minusThree;
    private Button minusTwo;
    private Button minusOne;
    private Button reset;
    private Button plusOne;
    private Button plusTwo;
    private Button plusThree;
    private TogglePictureButton[] toggleButtons = new TogglePictureButton[5];
    private EditBox signatureTextField;
    private EditBox usesTextField;
    private EditBox usableByTextField;
    private TextHoverChecker usesHoverChecker;
    private Button setUsesButton;
    private Button linkButton;
    private boolean firstTick = true;

    public KeycardReaderScreen(KeycardReaderMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.signature = this.previousSignature = Mth.m_14045_((int)this.be.getSignature(), (int)0, (int)99999);
        this.acceptedLevels = this.be.getAcceptedLevels();
        this.hasSmartModule = this.be.isModuleEnabled(ModuleType.SMART);
        this.isOwner = this.be.isOwnedBy((Entity)inv.f_35978_);
        this.f_97727_ = 249;
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:keycard_reader.smartModule", new Object[0]) : Utils.localize("gui.securitycraft:keycard_reader.noSmartModule", new Object[0]);
    }

    public void m_7856_() {
        super.m_7856_();
        int buttonHeight = 13;
        int buttonY = this.f_97736_ + 35;
        int activeButtons = 0;
        int firstActiveButton = -1;
        for (int i = 0; i < 5; ++i) {
            int thisButtonId = i;
            this.toggleButtons[i] = (TogglePictureButton)this.m_142416_((GuiEventListener)new TogglePictureButton(this.f_97735_ + 100, this.f_97736_ + 50 + (i + 1) * 17, 15, 15, BEACON_GUI, new int[]{110, 88}, new int[]{219, 219}, -1, 17, 17, 21, 22, 256, 256, 2, thisButton -> {
                if (!this.hasSmartModule) {
                    for (int otherButtonId = 0; otherButtonId < 5; ++otherButtonId) {
                        boolean active = this.isExactLevel ? otherButtonId == thisButtonId : otherButtonId >= thisButtonId;
                        this.changeLevelState(otherButtonId, active);
                    }
                } else {
                    this.acceptedLevels[thisButtonId] = !this.acceptedLevels[thisButtonId];
                }
            }));
            this.toggleButtons[i].setCurrentIndex(this.acceptedLevels[i] ? 1 : 0);
            this.toggleButtons[i].f_93623_ = this.isOwner;
            if (this.hasSmartModule || !this.acceptedLevels[i]) continue;
            if (firstActiveButton == -1) {
                firstActiveButton = i;
            }
            ++activeButtons;
        }
        this.signatureTextLength = this.f_96547_.m_92852_((FormattedText)this.signatureText);
        this.signatureTextStartX = this.f_97726_ / 2 - this.signatureTextLength + 5;
        this.signatureTextField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 96, this.f_97736_ + 21, 40, 12, (Component)Component.m_237119_()));
        this.signatureTextField.m_94144_(this.leftPaddedSignature());
        this.signatureTextField.m_94153_(s -> s.matches("\\d*"));
        this.signatureTextField.m_94199_(5);
        this.signatureTextField.m_94151_(this::changeSignature);
        this.minusThree = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 22, buttonY, 24, buttonHeight, (Component)Component.m_237113_((String)"---"), b -> this.changeSignature(this.signature - 100), Button.f_252438_));
        this.minusTwo = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 48, buttonY, 18, buttonHeight, (Component)Component.m_237113_((String)"--"), b -> this.changeSignature(this.signature - 10), Button.f_252438_));
        this.minusOne = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 68, buttonY, 12, buttonHeight, (Component)Component.m_237113_((String)"-"), b -> this.changeSignature(this.signature - 1), Button.f_252438_));
        this.reset = (Button)this.m_142416_((GuiEventListener)new ActiveBasedTextureButton(this.f_97735_ + 82, buttonY, 12, buttonHeight, RESET_TEXTURE, RESET_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSignature(this.previousSignature)));
        this.plusOne = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 96, buttonY, 12, buttonHeight, (Component)Component.m_237113_((String)"+"), b -> this.changeSignature(this.signature + 1), Button.f_252438_));
        this.plusTwo = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 110, buttonY, 18, buttonHeight, (Component)Component.m_237113_((String)"++"), b -> this.changeSignature(this.signature + 10), Button.f_252438_));
        this.plusThree = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 130, buttonY, 24, buttonHeight, (Component)Component.m_237113_((String)"+++"), b -> this.changeSignature(this.signature + 100), Button.f_252438_));
        Button randomizeButton = (Button)this.m_142416_((GuiEventListener)new ActiveBasedTextureButton(this.f_97735_ + 156, buttonY, 12, buttonHeight, RANDOM_TEXTURE, RANDOM_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSignature(this.f_96541_.f_91073_.f_46441_.m_188503_(99999))));
        randomizeButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:keycard_reader.randomize_signature", new Object[0])));
        randomizeButton.f_93623_ = this.isOwner;
        this.changeSignature(this.signature);
        this.linkButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 8, this.f_97736_ + 126, 70, 20, this.linkText, b -> {
            this.previousSignature = this.signature;
            this.changeSignature(this.signature);
            SecurityCraft.CHANNEL.sendToServer((Object)new SyncKeycardSettings(this.be.m_58899_(), this.acceptedLevels, this.signature, true, this.usableByTextField.m_94155_()));
            if (((KeycardReaderMenu)this.f_97732_).keycardSlot.m_7993_().m_41786_().getString().equalsIgnoreCase("Zelda")) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SCSounds.GET_ITEM.event, (float)1.0f, (float)1.25f));
            }
        }, Button.f_252438_));
        this.linkButton.f_93623_ = false;
        this.usableByTextField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 66, 70, 15, (Component)Component.m_237119_()));
        this.usableByTextField.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:keycard_reader.usable_by.tooltip", new Object[0])));
        this.usableByTextField.m_257771_((Component)Utils.localize("gui.securitycraft:keycard_reader.usable_by.hint", new Object[0]));
        this.usableByTextField.m_94199_(16);
        this.setUsesButton = (Button)this.m_142416_((GuiEventListener)new ActiveBasedTextureButton(this.f_97735_ + 62, this.f_97736_ + 106, 16, 17, RETURN_TEXTURE, RETURN_INACTIVE_TEXTURE, 14, 14, 2, 2, 14, 14, 14, 14, b -> SecurityCraft.CHANNEL.sendToServer((Object)new SetKeycardUses(this.be.m_58899_(), Integer.parseInt(this.usesTextField.m_94155_())))));
        this.setUsesButton.f_93623_ = false;
        this.usesTextField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 28, this.f_97736_ + 107, 30, 15, (Component)Component.m_237119_()));
        this.usesTextField.m_94153_(s -> s.matches("\\d*"));
        this.usesTextField.m_94199_(3);
        this.usesHoverChecker = new TextHoverChecker(this.f_97736_ + 107, this.f_97736_ + 122, this.f_97735_ + 28, this.f_97735_ + 58, this.limitedInfo);
        if (!this.hasSmartModule) {
            if (activeButtons == 1) {
                this.isExactLevel = true;
            } else if (activeButtons == 0) {
                this.isExactLevel = true;
                this.changeLevelState(0, true);
            } else {
                boolean active = false;
                this.isExactLevel = false;
                for (int i = 0; i < 5; ++i) {
                    if (i == firstActiveButton) {
                        active = true;
                    }
                    this.changeLevelState(i, active);
                }
            }
            ((Button)this.m_142416_((GuiEventListener)new Button((int)(this.f_97735_ + 135), (int)(this.f_97736_ + 67), (int)18, (int)18, (Component)(this.isExactLevel ? KeycardReaderScreen.EQUALS : KeycardReaderScreen.GREATER_THAN_EQUALS), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$13(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((KeycardReaderScreen)this), (Button.CreateNarration)Button.f_252438_))).f_93623_ = this.isOwner;
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(pose, this.signatureText, (float)this.signatureTextStartX, 23.0f, 0x404040);
        this.f_96547_.m_92889_(pose, this.keycardLevelsText, (float)(170 - this.f_96547_.m_92852_((FormattedText)this.keycardLevelsText)), 56.0f, 0x404040);
        for (int i = 1; i <= 5; ++i) {
            this.f_96547_.m_92883_(pose, "" + i, 91.0f, (float)(55 + 17 * i), 0x404040);
        }
        this.f_96547_.m_92889_(pose, Utils.INVENTORY_TEXT, 8.0f, (float)(this.f_97727_ - 93), 0x404040);
    }

    public void m_181908_() {
        super.m_181908_();
        ItemStack stack = ((KeycardReaderMenu)this.f_97732_).keycardSlot.m_7993_();
        boolean isEmpty = stack.m_41619_();
        boolean wasActive = this.usesTextField.f_93623_;
        boolean hasTag = stack.m_41782_();
        boolean enabled = !isEmpty && hasTag && stack.m_41783_().m_128471_("limited");
        int cardSignature = hasTag ? stack.m_41783_().m_128451_("signature") : -1;
        String usableBy = hasTag ? stack.m_41783_().m_128461_("usable_by") : "";
        this.usesTextField.m_94186_(enabled);
        this.usesTextField.f_93623_ = enabled;
        if (!wasActive && enabled) {
            this.usesTextField.m_94144_("" + stack.m_41783_().m_128451_("uses"));
        } else if (wasActive && !enabled) {
            this.usesTextField.m_94144_("");
        }
        if (this.firstTick) {
            this.setUsesButton.f_93623_ = false;
            this.linkButton.f_93623_ = false;
            this.firstTick = false;
        } else {
            this.setUsesButton.f_93623_ = enabled && this.usesTextField.m_94155_() != null && !this.usesTextField.m_94155_().isEmpty() && !("" + stack.m_41783_().m_128451_("uses")).equals(this.usesTextField.m_94155_());
            this.linkButton.f_93623_ = !isEmpty && (cardSignature != this.signature || !usableBy.equals(this.usableByTextField.m_94155_()));
        }
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(pose, mouseX, mouseY, partialTicks);
        ItemStack stack = ((KeycardReaderMenu)this.f_97732_).keycardSlot.m_7993_();
        if (!stack.m_41619_() && !this.acceptedLevels[((KeycardItem)stack.m_41720_()).getLevel()]) {
            int left = this.f_97735_ + 18;
            int top = this.f_97736_ + 82;
            RenderSystem.m_157179_((int)0, (ResourceLocation)WORLD_SELECTION_ICONS);
            KeycardReaderScreen.m_93160_((PoseStack)pose, (int)(left + 5), (int)(top + 4), (int)16, (int)16, (float)70.0f, (float)37.0f, (int)22, (int)22, (int)256, (int)256);
            if (mouseX >= left && mouseX <= left + 12 && mouseY >= top && mouseY <= top + 22) {
                this.m_96597_(pose, Arrays.asList(this.levelMismatchInfo), mouseX, mouseY);
            }
        }
        if (!this.usesTextField.f_93623_ && !stack.m_41619_() && this.usesHoverChecker.checkHover(mouseX, mouseY)) {
            this.m_96597_(pose, this.usesHoverChecker.getLines(), mouseX, mouseY);
        }
        this.m_7025_(pose, mouseX, mouseY);
        ClientUtils.renderModuleInfo(pose, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.f_97735_ + 5, this.f_97736_ + 5, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(pose);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        KeycardReaderScreen.m_93228_((PoseStack)pose, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isOwner && mouseX >= (double)(this.f_97735_ + this.signatureTextStartX) && mouseY >= (double)(this.f_97736_ + 23) && mouseX <= (double)(this.f_97735_ + this.signatureTextStartX + this.signatureTextLength + 42) && mouseY <= (double)(this.f_97736_ + 43)) {
            this.changeSignature(this.signature + (int)Math.signum(delta));
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key;
        if (this.usableByTextField.m_93696_() && (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key = InputConstants.m_84827_((int)keyCode, (int)scanCode)) || this.f_96541_.f_91066_.f_92093_.isActiveAndMatches(key) || this.f_96541_.f_91066_.f_92097_.isActiveAndMatches(key))) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.isOwner) {
            this.be.setAcceptedLevels(this.acceptedLevels);
            this.be.setSignature(this.signature);
            SecurityCraft.CHANNEL.sendToServer((Object)new SyncKeycardSettings(this.be.m_58899_(), this.acceptedLevels, this.signature, false, this.usableByTextField.m_94155_()));
        }
    }

    public void changeSignature(int newSignature) {
        this.changeSignature(newSignature, false);
    }

    public void changeSignature(String newSignature) {
        if (newSignature != null && !newSignature.isEmpty()) {
            this.changeSignature(Integer.parseInt(newSignature), true);
        }
    }

    public void changeSignature(int newSignature, boolean throughTextField) {
        boolean enableMinusButtons;
        if (this.isOwner) {
            this.signature = Mth.m_14045_((int)newSignature, (int)0, (int)99999);
        }
        boolean enablePlusButtons = this.isOwner && this.signature != 99999;
        this.minusThree.f_93623_ = enableMinusButtons = this.isOwner && this.signature != 0;
        this.minusTwo.f_93623_ = enableMinusButtons;
        this.minusOne.f_93623_ = enableMinusButtons;
        this.reset.f_93623_ = this.isOwner && this.signature != this.previousSignature;
        this.plusOne.f_93623_ = enablePlusButtons;
        this.plusTwo.f_93623_ = enablePlusButtons;
        this.plusThree.f_93623_ = enablePlusButtons;
        if (!throughTextField) {
            String textFieldValue = this.leftPaddedSignature();
            if (!this.signatureTextField.m_94155_().equals(textFieldValue)) {
                this.signatureTextField.m_94144_(textFieldValue);
            }
        }
    }

    public void changeLevelState(int i, boolean active) {
        if (this.isOwner) {
            this.toggleButtons[i].setCurrentIndex(active ? 1 : 0);
        }
        this.acceptedLevels[i] = active;
    }

    private String leftPaddedSignature() {
        return StringUtils.leftPad((String)("" + this.signature), (int)5, (String)"0");
    }

    private /* synthetic */ void lambda$init$13(Button b) {
        boolean change = false;
        this.isExactLevel = !this.isExactLevel;
        for (int i = 0; i < 5; ++i) {
            if (change) {
                this.changeLevelState(i, !this.isExactLevel);
                continue;
            }
            change = this.acceptedLevels[i];
        }
        b.m_93666_(this.isExactLevel ? EQUALS : GREATER_THAN_EQUALS);
    }
}

