/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.inventory.LaserBlockMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class LaserBlockScreen
extends AbstractContainerScreen<LaserBlockMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/laser_block.png");
    private final boolean hasSmartModule;
    private Component smartModuleTooltip;
    private LaserBlockBlockEntity be;
    private Map<Direction, Boolean> sideConfig;

    public LaserBlockScreen(LaserBlockMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.be = menu.be;
        this.sideConfig = menu.sideConfig;
        this.hasSmartModule = this.be.isModuleEnabled(ModuleType.SMART);
        this.f_97727_ = 256;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2;
        this.f_97731_ = this.f_97727_ - 94;
        this.sideConfig.forEach((dir, enabled) -> {
            CallbackCheckbox checkbox = new CallbackCheckbox(this.f_97735_ + 40, this.f_97736_ + dir.m_122411_() * 22 + 25, 20, 20, (Component)Utils.localize("gui.securitycraft:laser." + dir.m_122433_() + "Enabled", new Object[0]), (boolean)enabled, newValue -> this.onChangeValue((Direction)dir, (boolean)newValue), 0x404040){

                @Override
                public void m_5691_() {
                    if (LaserBlockScreen.this.hasSmartModule) {
                        super.m_5691_();
                    }
                }
            };
            checkbox.f_93623_ = this.be.isEnabled();
            this.m_142416_((GuiEventListener)checkbox);
        });
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:laser.smartModule", new Object[0]) : Utils.localize("gui.securitycraft:laser.noSmartModule", new Object[0]);
    }

    protected void m_7286_(PoseStack pose, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(pose);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        LaserBlockScreen.m_93228_((PoseStack)pose, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(pose, mouseX, mouseY, partialTicks);
        this.m_7025_(pose, mouseX, mouseY);
        ClientUtils.renderModuleInfo(pose, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.f_97735_ + 5, this.f_97736_ + 5, mouseX, mouseY);
    }

    public void onChangeValue(Direction dir, boolean newValue) {
        this.sideConfig.put(dir, newValue);
        SecurityCraft.CHANNEL.sendToServer((Object)new SyncLaserSideConfig(this.be.m_58899_(), this.sideConfig));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

