/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.items.LensItem;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IngredientDisplay;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class SCManualScreen
extends Screen {
    private static final ResourceLocation PAGE = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private static final ResourceLocation PAGE_WITH_SCROLL = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private static final ResourceLocation TITLE_PAGE = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private static final ResourceLocation ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static final ResourceLocation VANILLA_BOOK = new ResourceLocation("textures/gui/book.png");
    private static final int SUBPAGE_LENGTH = 1285;
    private static int lastPage = -1;
    private final MutableComponent intro1 = Utils.localize("gui.securitycraft:scManual.intro.1", new Object[0]).m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)));
    private final Component ourPatrons = Utils.localize("gui.securitycraft:scManual.patreon.title", new Object[0]);
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private IngredientDisplay[] displays = new IngredientDisplay[9];
    private int startX = -1;
    private List<FormattedText> subpages = new ArrayList<FormattedText>();
    private List<FormattedCharSequence> author = new ArrayList<FormattedCharSequence>();
    private int currentSubpage = 0;
    private List<FormattedCharSequence> intro2;
    private PatronList patronList;
    private Button patreonLinkButton;
    private Button nextSubpage;
    private Button previousSubpage;
    private boolean explosive;
    private boolean ownable;
    private boolean passcodeProtected;
    private boolean viewActivated;
    private boolean customizable;
    private boolean lockable;
    private boolean moduleInventory;
    private IngredientDisplay pageIcon;
    private Component pageTitle;
    private Component designedBy;

    public SCManualScreen() {
        super((Component)Component.m_237115_((String)((Item)SCContent.SC_MANUAL.get()).m_5524_()));
    }

    public void m_7856_() {
        int startY = 2;
        this.startX = (this.f_96543_ - 256) / 2;
        this.patreonLinkButton = (Button)this.m_142416_((GuiEventListener)new HyperlinkButton(this.startX + 225, 143, 16, 16, (Component)Component.m_237119_(), b -> this.m_5561_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/Geforce")))));
        this.patronList = (PatronList)this.m_142416_((GuiEventListener)new PatronList(this.f_96541_, 115, 90, 50, this.startX + 125));
        this.previousSubpage = (Button)this.m_142416_((GuiEventListener)new ChangePageButton(this.startX + 155, startY + 97, false, b -> this.previousSubpage()));
        this.nextSubpage = (Button)this.m_142416_((GuiEventListener)new ChangePageButton(this.startX + 180, startY + 97, true, b -> this.nextSubpage()));
        this.m_142416_((GuiEventListener)new ChangePageButton(this.startX + 22, startY + 188, false, b -> this.previousPage()));
        this.m_142416_((GuiEventListener)new ChangePageButton(this.startX + 210, startY + 188, true, b -> this.nextPage()));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.displays[i * 3 + j] = (IngredientDisplay)this.m_169394_(new IngredientDisplay(this.startX + 101 + j * 19, 144 + i * 19));
            }
        }
        this.pageIcon = (IngredientDisplay)this.m_169394_(new IngredientDisplay(this.startX + 19, 22));
        this.updateRecipeAndIcons();
        SCManualItem.PAGES.sort((page1, page2) -> {
            String key1 = page1.title().getString();
            String key2 = page2.title().getString();
            return key1.compareTo(key2);
        });
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        if (this.currentPage == -1) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)TITLE_PAGE);
        } else if (this.recipe != null && !this.recipe.isEmpty()) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)PAGE);
        } else {
            RenderSystem.m_157179_((int)0, (ResourceLocation)PAGE_WITH_SCROLL);
        }
        SCManualScreen.m_93228_((PoseStack)pose, (int)this.startX, (int)5, (int)0, (int)0, (int)256, (int)250);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_86412_(pose, mouseX, mouseY, partialTicks);
        }
        if (this.currentPage > -1) {
            pageNumberText = this.currentPage + 2 + "/" + (SCManualItem.PAGES.size() + 1);
            if (this.subpages.size() > 1) {
                this.f_96547_.m_92883_(pose, this.currentSubpage + 1 + "/" + this.subpages.size(), (float)(this.startX + 205), 102.0f, 9339504);
            }
            if (this.designedBy != null) {
                this.f_96547_.m_274535_(pose, (FormattedText)this.designedBy, this.startX + 18, 150, 75, 0);
            }
            this.f_96547_.m_92889_(pose, this.pageTitle, (float)(this.startX + 39), 27.0f, 0);
            this.f_96547_.m_274535_(pose, this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            this.f_96547_.m_92883_(pose, pageNumberText, (float)(this.startX + 240 - this.f_96547_.m_92895_(pageNumberText)), 182.0f, 9339504);
            RenderSystem.m_157179_((int)0, (ResourceLocation)ICONS);
            if (this.ownable) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 29), (int)118, (int)1, (int)1, (int)16, (int)16);
            }
            if (this.passcodeProtected) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 55), (int)118, (int)18, (int)1, (int)17, (int)16);
            }
            if (this.viewActivated) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 81), (int)118, (int)36, (int)1, (int)17, (int)16);
            }
            if (this.explosive) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 107), (int)117, (int)54, (int)1, (int)18, (int)18);
            }
            if (this.customizable) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 136), (int)118, (int)88, (int)1, (int)16, (int)16);
            }
            if (this.moduleInventory) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 163), (int)118, (int)105, (int)1, (int)16, (int)16);
            }
            if (this.lockable) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 189), (int)118, (int)154, (int)1, (int)16, (int)16);
            }
            if (this.customizable || this.moduleInventory) {
                SCManualScreen.m_93228_((PoseStack)pose, (int)(this.startX + 213), (int)118, (int)72, (int)1, (int)16, (int)16);
            }
            for (int i = 0; i < this.hoverCheckers.size(); ++i) {
                TextHoverChecker thc;
                HoverChecker chc = this.hoverCheckers.get(i);
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof TextHoverChecker && (thc = (TextHoverChecker)chc).getName() != null) {
                    this.m_96597_(pose, thc.getLines(), mouseX, mouseY);
                } else {
                    if (i >= this.displays.length || this.displays[i].getCurrentStack().m_41619_()) continue;
                    this.m_6057_(pose, this.displays[i].getCurrentStack(), mouseX, mouseY);
                }
                break;
            }
        } else {
            FormattedCharSequence text;
            int i;
            pageNumberText = "1/" + (SCManualItem.PAGES.size() + 1);
            this.f_96547_.m_92889_(pose, (Component)this.intro1, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.intro1) / 2), 22.0f, 0);
            for (i = 0; i < this.intro2.size(); ++i) {
                text = this.intro2.get(i);
                this.f_96547_.m_92877_(pose, text, (float)(this.f_96543_ / 2 - this.f_96547_.m_92724_(text) / 2), (float)(150 + 10 * i), 0);
            }
            for (i = 0; i < this.author.size(); ++i) {
                text = this.author.get(i);
                this.f_96547_.m_92877_(pose, text, (float)(this.f_96543_ / 2 - this.f_96547_.m_92724_(text) / 2), (float)(180 + 10 * i), 0);
            }
            this.f_96547_.m_92883_(pose, pageNumberText, (float)(this.startX + 240 - this.f_96547_.m_92895_(pageNumberText)), 182.0f, 9339504);
            this.f_96547_.m_92889_(pose, this.ourPatrons, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.ourPatrons) / 2 + 30), 40.0f, 0);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.pageIcon.tick();
        for (IngredientDisplay display : this.displays) {
            display.tick();
        }
    }

    public void m_7861_() {
        super.m_7861_();
        lastPage = this.currentPage;
    }

    private void hideSubpageButtonsOnMainPage() {
        this.nextSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (Screen.m_96638_()) {
            for (IngredientDisplay display : this.displays) {
                if (display == null) continue;
                display.changeRenderingStack(-scroll);
            }
            if (this.pageIcon != null) {
                this.pageIcon.changeRenderingStack(-scroll);
            }
            return true;
        }
        if (this.currentPage == -1 && this.patronList != null && this.patronList.m_5953_(mouseX, mouseY) && !this.patronList.patrons.isEmpty()) {
            this.patronList.m_6050_(mouseX, mouseY, scroll);
            return true;
        }
        if (Screen.m_96637_() && this.subpages.size() > 1) {
            switch ((int)Math.signum(scroll)) {
                case -1: {
                    this.nextSubpage();
                    break;
                }
                case 1: {
                    this.previousSubpage();
                }
            }
            return true;
        }
        switch ((int)Math.signum(scroll)) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        this.nextSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        return true;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SCManualItem.PAGES.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
        this.hideSubpageButtonsOnMainPage();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SCManualItem.PAGES.size() - 1;
        }
        this.updateRecipeAndIcons();
        this.hideSubpageButtonsOnMainPage();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        Object inWorldObject;
        this.currentSubpage = 0;
        this.hoverCheckers.clear();
        boolean bl = this.patreonLinkButton.f_93624_ = this.currentPage == -1;
        if (this.currentPage < 0) {
            for (IngredientDisplay display : this.displays) {
                display.setIngredient(Ingredient.f_43901_);
            }
            this.pageIcon.setIngredient(Ingredient.f_43901_);
            this.recipe = null;
            this.nextSubpage.f_93624_ = false;
            this.previousSubpage.f_93624_ = false;
            if (I18n.m_118936_((String)"gui.securitycraft:scManual.author")) {
                this.author = this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:scManual.author", new Object[0]), 180);
            } else {
                this.author.clear();
            }
            this.intro2 = this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:scManual.intro.2", new Object[0]), 202);
            this.patronList.fetchPatrons();
            return;
        }
        SCManualPage page = SCManualItem.PAGES.get(this.currentPage);
        String designerName = page.designedBy();
        Item item = page.item();
        PageGroup pageGroup = page.group();
        this.designedBy = designerName != null && !designerName.isEmpty() ? Utils.localize("gui.securitycraft:scManual.designedBy", designerName) : null;
        this.recipe = null;
        if (pageGroup == PageGroup.NONE) {
            level = Minecraft.m_91087_().f_91073_;
            registryAccess = level.m_9598_();
            for (Recipe object : level.m_7465_().m_44051_()) {
                if (object instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)object;
                    ItemStack resultItem = shapedRecipe.m_8043_(registryAccess);
                    if (!resultItem.m_150930_(item) || resultItem.m_150930_((Item)SCContent.LENS.get()) && ((LensItem)((Object)SCContent.LENS.get())).m_41113_(resultItem)) continue;
                    NonNullList ingredients = shapedRecipe.m_7527_();
                    NonNullList recipeItems = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
                    for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                        recipeItems.set(this.getCraftMatrixPosition(i2, shapedRecipe.m_44220_(), shapedRecipe.m_44221_()), (Object)((Ingredient)ingredients.get(i2)));
                    }
                    this.recipe = recipeItems;
                } else {
                    ShapelessRecipe shapelessRecipe;
                    if (!(object instanceof ShapelessRecipe) || !(shapelessRecipe = (ShapelessRecipe)object).m_8043_(registryAccess).m_150930_(item) || shapelessRecipe.m_6423_().m_135815_().endsWith("_reset")) continue;
                    NonNullList recipeItems = NonNullList.m_122780_((int)shapelessRecipe.m_7527_().size(), (Object)Ingredient.f_43901_);
                    for (int i3 = 0; i3 < recipeItems.size(); ++i3) {
                        recipeItems.set(i3, (Object)((Ingredient)shapelessRecipe.m_7527_().get(i3)));
                    }
                    this.recipe = recipeItems;
                }
                break;
            }
        } else if (pageGroup.hasRecipeGrid()) {
            level = Minecraft.m_91087_().f_91073_;
            registryAccess = level.m_9598_();
            HashMap<Integer, ItemStack[]> recipeStacks = new HashMap<Integer, ItemStack[]>();
            List<Item> pageItems = Arrays.stream(pageGroup.getItems().m_43908_()).map(ItemStack::m_41720_).toList();
            int stacksLeft = pageItems.size();
            for (int i4 = 0; i4 < 9; ++i4) {
                recipeStacks.put(i4, new ItemStack[pageItems.size()]);
            }
            for (Recipe object : Minecraft.m_91087_().f_91073_.m_7465_().m_44051_()) {
                ShapelessRecipe shapelessRecipe;
                int indexToAddAt;
                ItemStack[] items;
                int i5;
                NonNullList ingredients;
                if (stacksLeft == 0) break;
                if (object instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)object;
                    if (shapedRecipe.m_8043_(registryAccess).m_41619_() || !pageItems.contains(shapedRecipe.m_8043_(registryAccess).m_41720_())) continue;
                    ingredients = shapedRecipe.m_7527_();
                    for (i5 = 0; i5 < ingredients.size(); ++i5) {
                        items = ((Ingredient)ingredients.get(i5)).m_43908_();
                        if (items.length == 0) continue;
                        indexToAddAt = pageItems.indexOf(shapedRecipe.m_8043_(registryAccess).m_41720_());
                        ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)this.getCraftMatrixPosition((int)i5, (int)shapedRecipe.m_44220_(), (int)shapedRecipe.m_44221_()))))[indexToAddAt] = items[0];
                    }
                    --stacksLeft;
                    continue;
                }
                if (!(object instanceof ShapelessRecipe) || (shapelessRecipe = (ShapelessRecipe)object).m_8043_(registryAccess).m_41619_() || !pageItems.contains(shapelessRecipe.m_8043_(registryAccess).m_41720_()) || shapelessRecipe.m_6423_().m_135815_().endsWith("_reset")) continue;
                ingredients = shapelessRecipe.m_7527_();
                for (i5 = 0; i5 < ingredients.size(); ++i5) {
                    items = ((Ingredient)ingredients.get(i5)).m_43908_();
                    if (items.length == 0) continue;
                    indexToAddAt = pageItems.indexOf(shapelessRecipe.m_8043_(registryAccess).m_41720_());
                    ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)i5)))[indexToAddAt] = items[0];
                }
                --stacksLeft;
            }
            this.recipe = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            recipeStacks.forEach((i, stackArray) -> this.recipe.set(i.intValue(), (Object)Ingredient.m_43921_(Arrays.stream(stackArray).map(s -> s == null ? ItemStack.f_41583_ : s))));
        }
        if (page.hasRecipeDescription()) {
            String name = Utils.getRegistryName(page.item()).m_135815_();
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0])));
        } else if (pageGroup == PageGroup.REINFORCED || item == ((ReinforcedHopperBlock)SCContent.REINFORCED_HOPPER.get()).m_5456_()) {
            this.recipe = null;
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0])));
        } else if (this.recipe != null) {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    this.hoverCheckers.add(new HoverChecker(144 + row * 19, 144 + row * 19 + 16, this.startX + 101 + column * 19, this.startX + 101 + column * 19 + 16));
                }
            }
        } else {
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
        }
        this.pageTitle = page.title();
        if (pageGroup != PageGroup.NONE) {
            this.pageIcon.setIngredient(pageGroup.getItems());
        } else {
            this.pageIcon.setIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{page.item()}));
        }
        this.resetBlockEntityInfo();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            this.explosive = block instanceof IExplosive;
            if (this.explosive) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, (Component)Utils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0])));
            }
        }
        if ((inWorldObject = page.getInWorldObject()) != null) {
            IModuleInventory moduleInv;
            ICustomizable customizableObj;
            Option<?>[] options;
            this.ownable = inWorldObject instanceof IOwnable;
            this.passcodeProtected = inWorldObject instanceof IPasscodeProtected;
            this.viewActivated = inWorldObject instanceof IViewActivated;
            this.lockable = inWorldObject instanceof ILockable;
            if (this.ownable) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, (Component)Utils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0])));
            }
            if (this.passcodeProtected) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, (Component)Utils.localize("gui.securitycraft:scManual.passcodeProtectedBlock", new Object[0])));
            }
            if (this.viewActivated) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, (Component)Utils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0])));
            }
            if (inWorldObject instanceof ICustomizable && (options = (customizableObj = (ICustomizable)inWorldObject).customOptions()).length > 0) {
                ModuleType[] display = new ArrayList();
                this.customizable = true;
                display.add(Utils.localize("gui.securitycraft:scManual.options", new Object[0]));
                display.add(Component.m_237113_((String)"---"));
                for (Option<?> option : options) {
                    display.add(Component.m_237110_((String)"gui.securitycraft:scManual.option_text", (Object[])new Object[]{Component.m_237115_((String)option.getDescriptionKey(Utils.getLanguageKeyDenotation(customizableObj))), option.getDefaultInfo()}));
                    display.add(Component.m_237119_());
                }
                display.remove(display.size() - 1);
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, (List<? extends Component>)display));
            }
            if (inWorldObject instanceof IModuleInventory && (moduleInv = (IModuleInventory)inWorldObject).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                ArrayList<MutableComponent> display = new ArrayList<MutableComponent>();
                this.moduleInventory = true;
                display.add(Utils.localize("gui.securitycraft:scManual.modules", new Object[0]));
                display.add(Component.m_237113_((String)"---"));
                for (ModuleType module : moduleInv.acceptedModules()) {
                    display.add(Component.m_237113_((String)"- ").m_7220_((Component)Utils.localize(moduleInv.getModuleDescriptionId(Utils.getLanguageKeyDenotation(moduleInv), module), new Object[0])));
                    display.add(Component.m_237119_());
                }
                display.remove(display.size() - 1);
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, display));
            }
            if (this.lockable) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 189, this.startX + 189 + 16, (Component)Utils.localize("gui.securitycraft:scManual.lockable", new Object[0])));
            }
            if (this.customizable || this.moduleInventory) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, (Component)Utils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0])));
            }
        }
        if (this.recipe != null && !this.recipe.isEmpty()) {
            for (int i6 = 0; i6 < 3; ++i6) {
                for (int j = 0; j < 3; ++j) {
                    int index = i6 * 3 + j;
                    if (index >= this.recipe.size()) {
                        this.displays[index].setIngredient(Ingredient.f_43901_);
                        continue;
                    }
                    this.displays[index].setIngredient((Ingredient)this.recipe.get(index));
                }
            }
        } else {
            for (IngredientDisplay display : this.displays) {
                display.setIngredient(Ingredient.f_43901_);
            }
        }
        this.subpages = this.f_96547_.m_92865_().m_92414_((FormattedText)page.helpInfo(), 1285, Style.f_131099_);
        this.nextSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
    }

    private void resetBlockEntityInfo() {
        this.explosive = false;
        this.ownable = false;
        this.passcodeProtected = false;
        this.viewActivated = false;
        this.customizable = false;
        this.lockable = false;
        this.moduleInventory = false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.patronList != null) {
            this.patronList.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.patronList != null) {
            this.patronList.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private int getCraftMatrixPosition(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    static class HyperlinkButton
    extends Button {
        public HyperlinkButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler) {
            super(xPos, yPos, width, height, displayString, handler, s -> Component.m_237119_());
        }

        public void m_87963_(PoseStack pose, int mouseX, int mouseY, float partial) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)ICONS);
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            HyperlinkButton.m_93228_((PoseStack)pose, (int)this.m_252754_(), (int)this.m_252907_(), (int)(this.m_198029_() ? 138 : 122), (int)1, (int)16, (int)16);
        }
    }

    class PatronList
    extends ScrollPanel {
        private static final String PATRON_LIST_LINK = FMLEnvironment.production ? "https://gist.githubusercontent.com/bl4ckscor3/bdda6596012b1206816db034350b5717/raw" : "https://gist.githubusercontent.com/bl4ckscor3/3196e6740774e386871a74a9606eaa61/raw";
        private static final int SLOT_HEIGHT = 12;
        private final ExecutorService executor;
        private Future<List<String>> patronRequestFuture;
        private List<String> patrons;
        private boolean patronsAvailable;
        private boolean error;
        private boolean patronsRequested;
        private final List<FormattedCharSequence> fetchErrorLines;
        private final List<FormattedCharSequence> noPatronsLines;
        private final Component loadingText;

        public PatronList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 4, 6, -1061176398, -792740942, -7437712, -8359851, -3031135);
            this.executor = Executors.newSingleThreadExecutor();
            this.patrons = new ArrayList<String>();
            this.patronsAvailable = false;
            this.error = false;
            this.loadingText = Utils.localize("gui.securitycraft:scManual.patreon.loading", new Object[0]);
            this.fetchErrorLines = SCManualScreen.this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:scManual.patreon.error", new Object[0]), width);
            this.noPatronsLines = SCManualScreen.this.f_96547_.m_92923_((FormattedText)Utils.localize("advancements.empty", new Object[0]), width - 10);
        }

        protected int getContentHeight() {
            int n = this.patrons.size();
            Objects.requireNonNull(SCManualScreen.this.f_96547_);
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            if (SCManualScreen.this.currentPage == -1) {
                if (this.patronsAvailable) {
                    super.m_86412_(pose, mouseX, mouseY, partialTicks);
                    int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                    int slotIndex = mouseListY / 12;
                    if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.patrons.size() && mouseY >= this.top && mouseY <= this.bottom) {
                        String patron = this.patrons.get(slotIndex);
                        int length = SCManualScreen.this.f_96547_.m_92895_(patron);
                        int baseY = this.top + this.border - (int)this.scrollDistance;
                        if (length >= this.width - 6) {
                            SCManualScreen.this.m_169388_(pose, List.of(Component.m_237113_((String)patron)), Optional.empty(), this.left - 10, baseY + (12 * slotIndex + 12));
                        }
                    }
                    if (this.patrons.isEmpty()) {
                        for (int i = 0; i < this.noPatronsLines.size(); ++i) {
                            FormattedCharSequence line = this.noPatronsLines.get(i);
                            SCManualScreen.this.f_96547_.m_92877_(pose, line, (float)(this.left + this.width / 2 - SCManualScreen.this.f_96547_.m_92724_(line) / 2), (float)(this.top + 30 + i * 10), -13421773);
                        }
                    }
                } else if (this.error) {
                    for (int i = 0; i < this.fetchErrorLines.size(); ++i) {
                        FormattedCharSequence line = this.fetchErrorLines.get(i);
                        SCManualScreen.this.f_96547_.m_92877_(pose, line, (float)(this.left + this.width / 2 - SCManualScreen.this.f_96547_.m_92724_(line) / 2), (float)(this.top + 30 + i * 10), -5242623);
                    }
                } else if (this.patronRequestFuture != null && this.patronRequestFuture.isDone()) {
                    try {
                        this.patrons = this.patronRequestFuture.get();
                        this.executor.shutdown();
                        this.patronsAvailable = true;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.error = true;
                    }
                } else {
                    SCManualScreen.this.f_96547_.m_92889_(pose, this.loadingText, (float)(this.left + this.width / 2 - SCManualScreen.this.f_96547_.m_92852_((FormattedText)this.loadingText) / 2), (float)(this.top + 30), 0);
                }
            }
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.patrons.size(); ++i) {
                String patron = this.patrons.get(i);
                if (patron == null || patron.isEmpty()) continue;
                SCManualScreen.this.f_96547_.m_92883_(pose, patron, (float)(this.left + 2), (float)(relativeY + 12 * i), 0);
            }
        }

        public void fetchPatrons() {
            if (!this.patronsRequested) {
                this.patronRequestFuture = this.executor.submit(() -> {
                    List<String> list;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(PATRON_LIST_LINK).openStream()));
                    try {
                        list = reader.lines().toList();
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            this.error = true;
                            return new ArrayList();
                        }
                    }
                    reader.close();
                    return list;
                });
                this.patronsRequested = true;
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    static class ChangePageButton
    extends Button {
        private final int textureY;

        public ChangePageButton(int xPos, int yPos, boolean forward, Button.OnPress onPress) {
            super(xPos, yPos, 23, 13, (Component)Component.m_237119_(), onPress, f_252438_);
            this.textureY = forward ? 192 : 205;
        }

        public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                RenderSystem.m_157179_((int)0, (ResourceLocation)VANILLA_BOOK);
                ChangePageButton.m_93228_((PoseStack)pose, (int)this.m_252754_(), (int)this.m_252907_(), (int)(this.m_198029_() ? 23 : 0), (int)this.textureY, (int)23, (int)13);
            }
        }
    }
}

