/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class SSSConnectionList<T extends Screen>
extends ScrollPanel {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final int SLOT_HEIGHT = 12;
    private final T parent;
    private final List<ConnectionInfo> connectionInfo = new ArrayList<ConnectionInfo>();
    private final Font font;

    public SSSConnectionList(T parent, Minecraft client, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        this.parent = parent;
        this.font = client.f_91062_;
        this.refreshPositions();
    }

    public void refreshPositions() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        this.connectionInfo.clear();
        for (BlockPos pos : ((ConnectionAccessor)this.parent).getPositions()) {
            MutableComponent blockName;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof Nameable) {
                Nameable nameable = (Nameable)be;
                blockName = nameable.m_5446_();
            } else {
                blockName = be != null ? Utils.localize(be.m_58900_().m_60734_().m_7705_(), new Object[0]) : Component.m_237113_((String)"????");
            }
            this.connectionInfo.add(new ConnectionInfo(pos, (Component)blockName));
        }
    }

    protected int getContentHeight() {
        int height = this.connectionInfo.size() * 12;
        if (height < this.bottom - this.top - 4) {
            height = this.bottom - this.top - 4;
        }
        return height;
    }

    protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
        int baseY = this.top + this.border - (int)this.scrollDistance;
        int slotBuffer = 8;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        if (mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.connectionInfo.size() && mouseY >= this.top && mouseY <= this.bottom) {
            int min = this.left;
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * 12;
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.m_69461_();
            RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
            SSSConnectionList.m_93160_((PoseStack)pose, (int)this.left, (int)(slotTop - 3), (int)14, (int)14, (float)110.0f, (float)219.0f, (int)21, (int)22, (int)256, (int)256);
        }
        int i = 0;
        for (ConnectionInfo info : this.connectionInfo) {
            int yStart = relativeY + 12 * i++;
            this.font.m_92889_(pose, info.blockName, (float)(this.left + 13), (float)yStart, 0xC6C6C6);
        }
    }

    public void m_86412_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(pose, mouseX, mouseY, partialTicks);
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        if (slotIndex >= 0 && slotIndex < this.connectionInfo.size() && mouseListY >= 0 && mouseX >= this.left && mouseX < this.right - 6 && mouseY >= this.top && mouseY <= this.bottom) {
            Component blockName = this.connectionInfo.get((int)slotIndex).blockName;
            int length = this.font.m_92852_((FormattedText)blockName);
            int baseY = this.top + this.border - (int)this.scrollDistance;
            if (length + 13 >= this.width - 6) {
                this.parent.m_169388_(pose, List.of(blockName), Optional.empty(), this.left + 1, baseY + (12 * slotIndex + 12));
            }
            this.font.m_92889_(pose, Utils.getFormattedCoordinates(this.connectionInfo.get((int)slotIndex).pos), (float)(this.left + 13), (float)(this.top + this.height + 5), 0x404040);
        }
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        int slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12;
        if (slotIndex >= 0 && slotIndex < this.connectionInfo.size()) {
            Minecraft mc = Minecraft.m_91087_();
            double relativeMouseY = mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
            if (relativeMouseY >= (double)this.top && relativeMouseY <= (double)this.bottom && mouseX < 13.0) {
                ((ConnectionAccessor)this.parent).removePosition(this.connectionInfo.get((int)slotIndex).pos);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        }
        return false;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public static interface ConnectionAccessor {
        public Set<BlockPos> getPositions();

        public void removePosition(BlockPos var1);
    }

    private record ConnectionInfo(BlockPos pos, Component blockName) {
    }
}

