/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TeamUtils {
    private TeamUtils() {
    }

    public static boolean areOnSameTeam(Owner owner1, Owner owner2) {
        if (owner1.equals(owner2)) {
            return true;
        }
        if (!((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue()) {
            return false;
        }
        PlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner1.getName());
        return team != null && team.m_6809_().contains(owner2.getName());
    }

    public static PlayerTeam getVanillaTeamFromPlayer(String playerName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_129896_().m_83500_(playerName);
        }
        return ClientHandler.getClientPlayer().m_36329_().m_83500_(playerName);
    }

    public static TeamRepresentation getTeamRepresentation(Owner owner) {
        PlayerTeam team;
        if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && (team = TeamUtils.getVanillaTeamFromPlayer(owner.getName())) != null && team.m_6809_().size() > 1) {
            Integer color = team.m_7414_().m_126665_();
            return new TeamRepresentation(team.m_83364_().getString(), color == null ? ChatFormatting.GRAY.m_126665_() : color);
        }
        return null;
    }

    public static Collection<ServerPlayer> getOnlinePlayersFromOwner(MinecraftServer server, Owner owner) {
        PlayerTeam team;
        List<ServerPlayer> onlinePlayers = null;
        if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && (team = TeamUtils.getVanillaTeamFromPlayer(owner.getName())) != null) {
            onlinePlayers = team.m_6809_().stream().map(arg_0 -> ((PlayerList)server.m_6846_()).m_11255_(arg_0)).filter(Objects::nonNull).toList();
        }
        if (onlinePlayers == null || onlinePlayers.isEmpty()) {
            return PlayerUtils.getPlayerListFromOwner(owner);
        }
        return onlinePlayers;
    }

    public record TeamRepresentation(String name, int color) {
    }
}

