/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    public static final Component INVENTORY_TEXT = Utils.localize("container.inventory", new Object[0]);

    private Utils() {
    }

    public static Component getFormattedCoordinates(BlockPos pos) {
        return Component.m_237110_((String)"messages.securitycraft:formattedCoordinates", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public static MutableComponent localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            Object object = params[i];
            if (object instanceof Component && (object = (component = (Component)object).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents translatableContents = (TranslatableContents)object;
                params[i] = Utils.localize(translatableContents.m_237508_(), translatableContents.m_237523_());
                continue;
            }
            object = params[i];
            if (!(object instanceof BlockPos)) continue;
            BlockPos pos = (BlockPos)object;
            params[i] = Utils.getFormattedCoordinates(pos);
        }
        return Component.m_237110_((String)key, (Object[])params);
    }

    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entityType);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Potion potion) {
        return ForgeRegistries.POTIONS.getKey((Object)potion);
    }

    public static String getLanguageKeyDenotation(Object obj) {
        if (obj instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)obj;
            return Utils.getLanguageKeyDenotation(be.m_58900_().m_60734_());
        }
        if (obj instanceof Block) {
            Block block = (Block)obj;
            return block.m_7705_().substring(6);
        }
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return entity.m_6095_().m_147048_();
        }
        if (obj instanceof BlockState) {
            BlockState state = (BlockState)obj;
            return Utils.getLanguageKeyDenotation(state.m_60734_());
        }
        return "";
    }

    public static boolean isInViewDistance(int centerX, int centerZ, int viewDistance, int x, int z) {
        int reducedViewDistance;
        int squareViewDistance;
        int minDistance;
        int zDistance;
        int xDistance = Math.max(0, Math.abs(x - centerX) - 1);
        int reducedMaxDistance = Math.max(0, Math.max(xDistance, zDistance = Math.max(0, Math.abs(z - centerZ) - 1)) - 1);
        int squareDistance = reducedMaxDistance * reducedMaxDistance + (minDistance = Math.min(xDistance, zDistance)) * minDistance;
        return squareDistance <= (squareViewDistance = (reducedViewDistance = viewDistance - 1) * reducedViewDistance);
    }

    public static void updateBlockEntityWithItemTag(BlockEntity be, ItemStack stack) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null) {
            CompoundTag beData = be.m_187482_();
            CompoundTag dataCopy = beData.m_6426_();
            beData.m_128391_(tag);
            if (!beData.equals((Object)dataCopy)) {
                be.m_142466_(beData);
                be.m_6596_();
            }
        }
    }
}

