/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.content;

import com.satherov.luminax.content.LuminaxRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BlockSet {
    public final String name;
    public final boolean dyenamic;
    private static final List<BlockSet> instances = new ArrayList<BlockSet>();
    public final DeferredHolder<Block, Block> BLOCK;
    public final DeferredHolder<Block, StairBlock> STAIRS;
    public final DeferredHolder<Block, SlabBlock> SLAB;
    public final DeferredHolder<Block, WallBlock> WALL;
    public final DeferredHolder<Block, PressurePlateBlock> PRESSURE_PLATE;
    public final DeferredHolder<Block, ButtonBlock> BUTTON;
    public final DeferredHolder<Block, Block> DIM_BLOCK;
    public final DeferredHolder<Block, StairBlock> DIM_STAIRS;
    public final DeferredHolder<Block, SlabBlock> DIM_SLAB;
    public final DeferredHolder<Block, WallBlock> DIM_WALL;
    public final DeferredHolder<Block, PressurePlateBlock> DIM_PRESSURE_PLATE;
    public final DeferredHolder<Block, ButtonBlock> DIM_BUTTON;

    public static List<BlockSet> getSets() {
        return instances;
    }

    public BlockSet(String name, boolean dyenamic) {
        this.name = name;
        this.dyenamic = dyenamic;
        instances.add(this);
        this.BLOCK = BlockSet.register(String.format("%s_block", name), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(state -> 15)), dyenamic);
        this.STAIRS = BlockSet.register(String.format("%s_stairs", name), () -> new StairBlock(((Block)this.BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).lightLevel(state -> 15)), dyenamic);
        this.SLAB = BlockSet.register(String.format("%s_slab", name), () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).lightLevel(state -> 15)), dyenamic);
        this.WALL = BlockSet.register(String.format("%s_wall", name), () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_WALL).lightLevel(state -> 15)), dyenamic);
        this.PRESSURE_PLATE = BlockSet.register(String.format("%s_pressure_plate", name), () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE).lightLevel(state -> 15)), dyenamic);
        this.BUTTON = BlockSet.register(String.format("%s_button", name), () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON).lightLevel(state -> 15)), dyenamic);
        this.DIM_BLOCK = BlockSet.register(String.format("dim_%s_block", name), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)), dyenamic);
        this.DIM_STAIRS = BlockSet.register(String.format("dim_%s_stairs", name), () -> new StairBlock(((Block)this.BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS)), dyenamic);
        this.DIM_SLAB = BlockSet.register(String.format("dim_%s_slab", name), () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB)), dyenamic);
        this.DIM_WALL = BlockSet.register(String.format("dim_%s_wall", name), () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_WALL)), dyenamic);
        this.DIM_PRESSURE_PLATE = BlockSet.register(String.format("dim_%s_pressure_plate", name), () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE)), dyenamic);
        this.DIM_BUTTON = BlockSet.register(String.format("dim_%s_button", name), () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON)), dyenamic);
    }

    private static <T extends Block> DeferredHolder<Block, T> register(String name, Supplier<T> properties, boolean dyenamic) {
        DeferredHolder block;
        if (dyenamic) {
            block = LuminaxRegistry.DYENAMIC_BLOCKS.register(name, properties);
            LuminaxRegistry.DYENAMIC_ITEMS.registerSimpleBlockItem(name, (Supplier)block);
        } else {
            block = LuminaxRegistry.BLOCKS.register(name, properties);
            LuminaxRegistry.ITEMS.registerSimpleBlockItem(name, (Supplier)block);
        }
        return block;
    }
}

