/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.assets;

import com.satherov.luminax.content.SetHelper;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class LuminaxBlockStateProvider
extends BlockStateProvider {
    public LuminaxBlockStateProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator.getPackOutput(), "luminax", fileHelper);
    }

    protected void registerStatesAndModels() {
        SetHelper.apply(set -> {
            this.simpleBlock((Block)set.BLOCK.get(), this.getExistingFile(set.BLOCK.getId().getPath()));
            this.slabBlock(set.SLAB, set.BLOCK);
            this.stairsBlock(set.STAIRS);
            this.buttonBlock(set.BUTTON);
            this.pressurePlateBlock(set.PRESSURE_PLATE);
            this.wallBlock(set.WALL);
            this.simpleBlock((Block)set.DIM_BLOCK.get(), this.getExistingFile(set.DIM_BLOCK.getId().getPath()));
            this.slabBlock(set.DIM_SLAB, set.DIM_BLOCK);
            this.stairsBlock(set.DIM_STAIRS);
            this.buttonBlock(set.DIM_BUTTON);
            this.pressurePlateBlock(set.DIM_PRESSURE_PLATE);
            this.wallBlock(set.DIM_WALL);
        });
    }

    private ResourceLocation block(DeferredHolder<Block, ? extends Block> block) {
        return this.modLoc("block/" + block.getId().getPath());
    }

    private ModelFile getExistingFile(String path) {
        return this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)path));
    }

    public void slabBlock(DeferredHolder<Block, ? extends SlabBlock> slab, DeferredHolder<Block, ? extends Block> block) {
        this.getVariantBuilder((Block)slab.get()).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(slab.getId().getPath()))}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(slab.getId().getPath() + "_top"))}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.block(block)))});
    }

    public void stairsBlock(DeferredHolder<Block, ? extends StairBlock> stair) {
        this.getVariantBuilder((Block)stair.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            int yRot = (int)facing.getClockWise().toYRot();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? this.getExistingFile(stair.getId().getPath()) : (shape != StairsShape.INNER_LEFT && shape != StairsShape.INNER_RIGHT ? this.getExistingFile(stair.getId().getPath() + "_outer") : this.getExistingFile(stair.getId().getPath() + "_inner"))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{StairBlock.WATERLOGGED});
    }

    public void buttonBlock(DeferredHolder<Block, ? extends ButtonBlock> button) {
        this.getVariantBuilder((Block)button.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)ButtonBlock.FACING);
            AttachFace face = (AttachFace)state.getValue((Property)ButtonBlock.FACE);
            boolean powered = (Boolean)state.getValue((Property)ButtonBlock.POWERED);
            return ConfiguredModel.builder().modelFile(powered ? this.getExistingFile(button.getId().getPath() + "_pressed") : this.getExistingFile(button.getId().getPath())).rotationX(face == AttachFace.FLOOR ? 0 : (face == AttachFace.WALL ? 90 : 180)).rotationY((int)(face == AttachFace.CEILING ? facing : facing.getOpposite()).toYRot()).uvLock(face == AttachFace.WALL).build();
        });
    }

    public void pressurePlateBlock(DeferredHolder<Block, ? extends PressurePlateBlock> pressurePlate) {
        this.getVariantBuilder((Block)pressurePlate.get()).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(pressurePlate.getId().getPath() + "_down"))}).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(pressurePlate.getId().getPath()))});
    }

    public void wallBlock(DeferredHolder<Block, ? extends WallBlock> wall) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)wall.get()).part().modelFile(this.getExistingFile(wall.getId().getPath() + "_post")).addModel()).condition((Property)WallBlock.UP, (Comparable[])new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).getAxis().isHorizontal()).forEach(e -> {
            this.wallSidePart(builder, this.getExistingFile(wall.getId().getPath() + "_side"), (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW);
            this.wallSidePart(builder, this.getExistingFile(wall.getId().getPath() + "_side_tall"), (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL);
        });
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)entry.getKey().toYRot() + 180) % 360).uvLock(true).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height});
    }
}

