/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.assets;

import com.satherov.luminax.content.SetHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class LuminaxItemModelProvider
extends ItemModelProvider {
    public LuminaxItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "luminax", existingFileHelper);
    }

    protected void registerModels() {
        SetHelper.apply(set -> {
            this.blockModel(set.BLOCK);
            this.blockModel(set.SLAB);
            this.blockModel(set.STAIRS);
            this.blockModel(set.WALL);
            this.blockModel(set.PRESSURE_PLATE);
            this.buttonModel(set.BUTTON);
            this.blockModel(set.DIM_BLOCK);
            this.blockModel(set.DIM_SLAB);
            this.blockModel(set.DIM_STAIRS);
            this.blockModel(set.DIM_WALL);
            this.blockModel(set.DIM_PRESSURE_PLATE);
            this.buttonModel(set.DIM_BUTTON);
        });
    }

    public void blockModel(DeferredHolder<Block, ? extends Block> block) {
        this.withExistingParent(block.getId().getPath(), this.modLoc("block/" + block.getId().getPath()));
    }

    public void buttonModel(DeferredHolder<Block, ? extends ButtonBlock> block) {
        this.withExistingParent(block.getId().getPath(), this.modLoc("block/" + block.getId().getPath() + "_inventory"));
    }
}

