/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp;

import com.rexon.rtp.commands.RTPCommand;
import com.rexon.rtp.listeners.InventoryListener;
import com.rexon.rtp.listeners.PlayerDamageListener;
import com.rexon.rtp.listeners.PlayerMoveListener;
import com.rexon.rtp.listeners.PlayerQuitListener;
import com.rexon.rtp.managers.ConfigManager;
import com.rexon.rtp.managers.CooldownManager;
import com.rexon.rtp.managers.LocationSearchManager;
import com.rexon.rtp.managers.MovementDetectionManager;
import com.rexon.rtp.managers.SoundManager;
import com.rexon.rtp.managers.TeleportManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class RexonRTP
extends JavaPlugin {
    private static RexonRTP instance;
    private ConfigManager configManager;
    private CooldownManager cooldownManager;
    private LocationSearchManager locationSearchManager;
    private TeleportManager teleportManager;
    private SoundManager soundManager;
    private MovementDetectionManager movementDetectionManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.soundManager = new SoundManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.locationSearchManager = new LocationSearchManager(this);
        this.movementDetectionManager = new MovementDetectionManager(this);
        this.teleportManager = new TeleportManager(this);
        RTPCommand rtpCommand = new RTPCommand(this);
        this.getCommand("rtp").setExecutor((CommandExecutor)rtpCommand);
        this.getCommand("rtp").setTabCompleter((TabCompleter)rtpCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDamageListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        this.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.getLogger().info("\u2551            REXON RTP v1.0            \u2551");
        this.getLogger().info("\u2551        by VYREXEN - Enabled!        \u2551");
        this.getLogger().info("\u2551     Movement Detection: " + (this.configManager.isMovementDetectionEnabled() ? "ON" : "OFF") + "      \u2551");
        this.getLogger().info("\u2551     Detection Method: " + this.configManager.getMovementDetectionMethod() + "        \u2551");
        this.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public void onDisable() {
        if (this.movementDetectionManager != null) {
            this.movementDetectionManager.cleanup();
        }
        if (this.teleportManager != null) {
            this.teleportManager.cleanup();
        }
        this.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.getLogger().info("\u2551           REXON RTP v1.0             \u2551");
        this.getLogger().info("\u2551       by VYREXEN - Disabled!        \u2551");
        this.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public static RexonRTP getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public LocationSearchManager getLocationSearchManager() {
        return this.locationSearchManager;
    }

    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public MovementDetectionManager getMovementDetectionManager() {
        return this.movementDetectionManager;
    }

    public void reloadPlugin() {
        this.configManager.reloadConfig();
        this.soundManager.reloadSounds();
        this.getLogger().info("RexonRTP configuration reloaded!");
    }
}

