/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.commands;

import com.rexon.rtp.RexonRTP;
import com.rexon.rtp.managers.ConfigManager;
import com.rexon.rtp.utils.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RTPCommand
implements CommandExecutor,
TabCompleter {
    private final RexonRTP plugin;

    public RTPCommand(RexonRTP plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("players-only"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("rexonrtp.use")) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            if (!player.hasPermission("rexonrtp.bypass")) {
                if (!this.plugin.getCooldownManager().canUseRTP(player)) {
                    long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player);
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("time", String.valueOf(remaining));
                    String messageKey = player.hasPermission("rexonrtp.premium") ? "cooldown-premium" : "cooldown-default";
                    player.sendMessage(this.plugin.getConfigManager().getMessage(messageKey, placeholders));
                    return true;
                }
                if (this.plugin.getTeleportManager().isTeleporting(player)) {
                    player.sendMessage(this.plugin.getConfigManager().getMessage("already-teleporting"));
                    return true;
                }
            }
            if (args.length == 0) {
                this.plugin.getTeleportManager().openRTPGUI(player);
                return true;
            }
            String worldInput = args[0];
            World world = WorldUtils.getWorldByNameOrAlias(worldInput);
            if (world == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("world-not-found"));
                return true;
            }
            this.plugin.getTeleportManager().startRTPProcess(player, worldInput);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error executing RTP command: " + e.getMessage());
            e.printStackTrace();
            sender.sendMessage("\u00a7cAn error occurred while processing the command. Please try again.");
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        try {
            if (args.length == 1 && sender.hasPermission("rexonrtp.use")) {
                ArrayList<String> completions = new ArrayList<String>();
                Map<String, ConfigManager.GUIItem> items = this.plugin.getConfigManager().getGUIItems();
                for (ConfigManager.GUIItem item : items.values()) {
                    World world2 = WorldUtils.getWorldByNameOrAlias(item.world);
                    if (world2 == null || !this.plugin.getConfigManager().isWorldEnabled(item.world)) continue;
                    completions.add(item.world);
                }
                String input = args[0].toLowerCase();
                completions.removeIf(world -> !world.toLowerCase().startsWith(input));
                return completions;
            }
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in tab completion: " + e.getMessage());
            return null;
        }
    }
}

