/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.listeners;

import com.rexon.rtp.RexonRTP;
import com.rexon.rtp.managers.ConfigManager;
import com.rexon.rtp.utils.WorldUtils;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;

public class InventoryListener
implements Listener {
    private final RexonRTP plugin;

    public InventoryListener(RexonRTP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        String guiTitle = this.plugin.getConfigManager().getGUITitle();
        if (!title.equals(guiTitle)) {
            return;
        }
        Inventory clickedInventory = event.getClickedInventory();
        Inventory topInventory = event.getView().getTopInventory();
        if (clickedInventory != null && clickedInventory.equals((Object)topInventory)) {
            event.setCancelled(true);
        } else if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            event.setCancelled(true);
        } else if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR && event.getCurrentItem() != null && topInventory.contains(event.getCurrentItem().getType())) {
            event.setCancelled(true);
        }
        if (event.getClickedInventory() != null && event.getClickedInventory().equals((Object)event.getView().getTopInventory())) {
            if (!player.hasPermission("rexonrtp.bypass") && this.plugin.getTeleportManager().isTeleporting(player)) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("already-teleporting"));
                player.closeInventory();
                return;
            }
            int slot = event.getSlot();
            player.closeInventory();
            Map<String, ConfigManager.GUIItem> items = this.plugin.getConfigManager().getGUIItems();
            for (ConfigManager.GUIItem item : items.values()) {
                if (item.slot != slot) continue;
                World world = WorldUtils.getWorldByNameOrAlias(item.world);
                if (world != null) {
                    this.plugin.getSoundManager().playGUIClickSound(player);
                    this.plugin.getTeleportManager().startRTPProcess(player, item.world);
                }
                return;
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        String guiTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (!title.equals(guiTitle = this.plugin.getConfigManager().getGUITitle())) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot >= topInventory.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }
}

