/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.listeners;

import com.rexon.rtp.RexonRTP;
import java.util.HashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class PlayerDamageListener
implements Listener {
    private final RexonRTP plugin;

    public PlayerDamageListener(RexonRTP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.hasPermission("rexonrtp.bypass") && this.plugin.getTeleportManager().isTeleporting(player)) {
            this.plugin.getTeleportManager().cleanupTeleportData(player);
            player.sendMessage(this.plugin.getConfigManager().getMessage("cancelled-damage"));
            this.plugin.getSoundManager().playTeleportCancelledSound(player);
        }
    }

    @EventHandler
    public void onPlayerDamageByPlayer(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity2;
        if (this.plugin.getTeleportManager().isProtected(victim)) {
            event.setCancelled(true);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", victim.getName());
            attacker.sendMessage(this.plugin.getConfigManager().getMessage("cannot-damage", placeholders));
            victim.sendMessage(this.plugin.getConfigManager().getMessage("protection-message"));
        }
    }
}

