/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.listeners;

import com.rexon.rtp.RexonRTP;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener
implements Listener {
    private final RexonRTP plugin;

    public PlayerMoveListener(RexonRTP plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        if (!this.plugin.getMovementDetectionManager().isTracking(player)) {
            return;
        }
        if (!this.hasActuallyMoved(from, to)) {
            return;
        }
        this.plugin.getMovementDetectionManager().checkMovementFromEvent(player, from, to);
    }

    private boolean hasActuallyMoved(Location from, Location to) {
        double deltaX = Math.abs(to.getX() - from.getX());
        double deltaY = Math.abs(to.getY() - from.getY());
        double deltaZ = Math.abs(to.getZ() - from.getZ());
        return deltaX > 0.001 || deltaY > 0.001 || deltaZ > 0.001;
    }
}

