/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.managers;

import com.rexon.rtp.RexonRTP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigManager {
    private final RexonRTP plugin;

    public ConfigManager(RexonRTP plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        plugin.reloadConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
    }

    public String getMessage(String key) {
        String message = this.plugin.getConfig().getString("messages." + key, "&cMessage not found: " + key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    public long getCooldown(boolean isPremium) {
        if (isPremium) {
            return this.plugin.getConfig().getLong("rtp.cooldown.premium", 3L);
        }
        return this.plugin.getConfig().getLong("rtp.cooldown.default", 10L);
    }

    public int getCountdownTime() {
        return this.plugin.getConfig().getInt("rtp.teleport.countdown", 5);
    }

    public int getMaxSearchAttempts() {
        return this.plugin.getConfig().getInt("rtp.teleport.max-search-attempts", 20);
    }

    public long getProtectionTime() {
        return this.plugin.getConfig().getLong("rtp.teleport.protection-time", 5000L);
    }

    public double getMovementThreshold() {
        return this.plugin.getConfig().getDouble("rtp.movement-detection.threshold", 0.5);
    }

    public String getWorldName(String dimension) {
        return this.plugin.getConfig().getString("rtp.worlds." + dimension + ".name", "world");
    }

    public boolean isWorldEnabled(String dimension) {
        return this.plugin.getConfig().getBoolean("rtp.worlds." + dimension + ".enabled", true);
    }

    public int getMinDistance(String dimension) {
        return this.plugin.getConfig().getInt("rtp.worlds." + dimension + ".min-distance", 100);
    }

    public int getMaxDistance(String dimension) {
        return this.plugin.getConfig().getInt("rtp.worlds." + dimension + ".max-distance", 50000);
    }

    public String getGUITitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("gui.title", "&8Random Teleport"));
    }

    public Map<String, GUIItem> getGUIItems() {
        HashMap<String, GUIItem> items = new HashMap<String, GUIItem>();
        ConfigurationSection itemsSection = this.plugin.getConfig().getConfigurationSection("gui.items");
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                try {
                    Material material = Material.valueOf((String)itemSection.getString("material", "GRASS_BLOCK"));
                    String name = ChatColor.translateAlternateColorCodes((char)'&', (String)itemSection.getString("name", "&f" + key));
                    List lore = itemSection.getStringList("lore");
                    int slot = itemSection.getInt("slot", 11);
                    String world = itemSection.getString("world", key);
                    if (slot < 0 || slot > 26) {
                        this.plugin.getLogger().warning("Invalid slot " + slot + " for item " + key + " in 3-row GUI, using slot 11");
                        slot = 11;
                    }
                    for (int i = 0; i < lore.size(); ++i) {
                        lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(i))));
                    }
                    items.put(key, new GUIItem(material, name, lore, slot, world));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid material for item " + key + ": " + e.getMessage());
                }
            }
        }
        return items;
    }

    public boolean isMovementDetectionEnabled() {
        return this.plugin.getConfig().getBoolean("rtp.movement-detection.enabled", true);
    }

    public String getMovementDetectionMethod() {
        return this.plugin.getConfig().getString("rtp.movement-detection.method", "HYBRID").toUpperCase();
    }

    public int getMovementCheckInterval() {
        return this.plugin.getConfig().getInt("rtp.movement-detection.check-interval", 1);
    }

    public boolean shouldIgnoreMicroMovements() {
        return this.plugin.getConfig().getBoolean("rtp.movement-detection.ignore-micro-movements", true);
    }

    public boolean shouldDetectVertical() {
        return this.plugin.getConfig().getBoolean("rtp.movement-detection.detect-vertical", true);
    }

    public boolean shouldDetectHorizontal() {
        return this.plugin.getConfig().getBoolean("rtp.movement-detection.detect-horizontal", true);
    }

    public boolean shouldTrackRotation() {
        return this.plugin.getConfig().getBoolean("rtp.movement-detection.track-rotation", false);
    }

    public static class GUIItem {
        public final Material material;
        public final String name;
        public final List<String> lore;
        public final int slot;
        public final String world;

        public GUIItem(Material material, String name, List<String> lore, int slot, String world) {
            this.material = material;
            this.name = name;
            this.lore = lore;
            this.slot = slot;
            this.world = world;
        }
    }
}

