/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.managers;

import com.rexon.rtp.RexonRTP;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final RexonRTP plugin;
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public CooldownManager(RexonRTP plugin) {
        this.plugin = plugin;
    }

    public boolean canUseRTP(Player player) {
        if (player.hasPermission("rexonrtp.bypass")) {
            return true;
        }
        Long cooldownEnd = this.cooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return true;
        }
        return System.currentTimeMillis() >= cooldownEnd;
    }

    public void setCooldown(Player player) {
        if (player.hasPermission("rexonrtp.bypass")) {
            return;
        }
        boolean isPremium = player.hasPermission("rexonrtp.premium");
        long cooldownTime = this.plugin.getConfigManager().getCooldown(isPremium);
        long cooldownEnd = System.currentTimeMillis() + cooldownTime * 1000L;
        this.cooldowns.put(player.getUniqueId(), cooldownEnd);
    }

    public long getRemainingCooldown(Player player) {
        Long cooldownEnd = this.cooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = (cooldownEnd - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    public void removeCooldown(Player player) {
        this.cooldowns.remove(player.getUniqueId());
    }

    public void clearAllCooldowns() {
        this.cooldowns.clear();
    }
}

