/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.managers;

import com.rexon.rtp.RexonRTP;
import com.rexon.rtp.utils.LocationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LocationSearchManager {
    private final RexonRTP plugin;
    private final Random random = new Random();
    private final Map<UUID, Integer> searchAttempts = new ConcurrentHashMap<UUID, Integer>();

    public LocationSearchManager(RexonRTP plugin) {
        this.plugin = plugin;
    }

    public void searchLocationAsync(Player player, World targetWorld) {
        try {
            int attempts = this.searchAttempts.getOrDefault(player.getUniqueId(), 0);
            int maxAttempts = this.plugin.getConfigManager().getMaxSearchAttempts();
            if (attempts >= maxAttempts) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("attempts", String.valueOf(maxAttempts));
                player.sendMessage(this.plugin.getConfigManager().getMessage("search-failed", placeholders));
                this.plugin.getSoundManager().playTeleportCancelledSound(player);
                this.searchAttempts.remove(player.getUniqueId());
                this.plugin.getTeleportManager().cleanupTeleportData(player);
                return;
            }
            this.searchAttempts.put(player.getUniqueId(), attempts + 1);
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.findSafeLocationFast(targetWorld)).thenAccept(safeLocation -> new BukkitRunnable(this, (Location)safeLocation, player, targetWorld){
                final /* synthetic */ Location val$safeLocation;
                final /* synthetic */ Player val$player;
                final /* synthetic */ World val$targetWorld;
                final /* synthetic */ LocationSearchManager this$0;
                {
                    this.val$safeLocation = location;
                    this.val$player = player;
                    this.val$targetWorld = world;
                    this.this$0 = this$0;
                }

                public void run() {
                    if (this.val$safeLocation != null) {
                        this.this$0.searchAttempts.remove(this.val$player.getUniqueId());
                        this.this$0.plugin.getTeleportManager().teleportPlayerSafely(this.val$player, this.val$safeLocation);
                    } else {
                        this.this$0.searchLocationAsync(this.val$player, this.val$targetWorld);
                    }
                }
            }.runTask((Plugin)this.plugin))).exceptionally(throwable -> {
                this.plugin.getLogger().severe("Location search error: " + throwable.getMessage());
                this.searchAttempts.remove(player.getUniqueId());
                this.plugin.getTeleportManager().cleanupTeleportData(player);
                return null;
            });
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error starting location search: " + e.getMessage());
            this.searchAttempts.remove(player.getUniqueId());
            this.plugin.getTeleportManager().cleanupTeleportData(player);
        }
    }

    private Location findSafeLocationFast(World world) {
        try {
            String worldName = world.getName().toLowerCase();
            String dimensionKey = this.getDimensionKey(worldName);
            int minDistance = this.plugin.getConfigManager().getMinDistance(dimensionKey);
            int maxDistance = this.plugin.getConfigManager().getMaxDistance(dimensionKey);
            int range = maxDistance - minDistance;
            int x = this.random.nextInt(range) + minDistance;
            int z = this.random.nextInt(range) + minDistance;
            if (this.random.nextBoolean()) {
                x = -x;
            }
            if (this.random.nextBoolean()) {
                z = -z;
            }
            if (world.getEnvironment() == World.Environment.NETHER) {
                return this.findSafeNetherLocation(x, z, world);
            }
            return this.findSafeOverworldLocation(x, z, world);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error finding safe location: " + e.getMessage());
            return null;
        }
    }

    private Location findSafeOverworldLocation(int x, int z, World world) {
        try {
            int highestY = world.getHighestBlockYAt(x, z);
            for (int y = Math.min(highestY + 2, world.getMaxHeight() - 10); y >= Math.max(world.getMinHeight() + 10, -60); --y) {
                Location testLoc = new Location(world, (double)x, (double)y, (double)z);
                if (!LocationUtils.isLocationSafeEnhanced(testLoc) || !this.isAirColumnToSky(testLoc)) continue;
                return new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error finding overworld location: " + e.getMessage());
        }
        return null;
    }

    private Location findSafeNetherLocation(int x, int z, World world) {
        try {
            for (int y = 120; y >= 10; --y) {
                Location testLoc = new Location(world, (double)x, (double)y, (double)z);
                if (!LocationUtils.isNetherLocationSafeEnhanced(testLoc)) continue;
                return new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error finding nether location: " + e.getMessage());
        }
        return null;
    }

    private boolean isAirColumnToSky(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        int x = location.getBlockX();
        int z = location.getBlockZ();
        int startY = location.getBlockY() + 2;
        int maxY = world.getMaxHeight() - 1;
        for (int y = startY; y <= maxY; ++y) {
            Material blockType = world.getBlockAt(x, y, z).getType();
            if (blockType == Material.AIR || blockType == Material.CAVE_AIR || blockType == Material.VOID_AIR) continue;
            return false;
        }
        return true;
    }

    private String getDimensionKey(String worldName) {
        if (worldName.contains("nether")) {
            return "nether";
        }
        if (worldName.contains("end")) {
            return "end";
        }
        if (this.plugin.getConfig().getConfigurationSection("rtp.worlds." + worldName) != null) {
            return worldName;
        }
        return "overworld";
    }
}

