/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.managers;

import com.rexon.rtp.RexonRTP;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MovementDetectionManager {
    private final RexonRTP plugin;
    private final Map<UUID, MovementTrackingData> trackedPlayers = new ConcurrentHashMap<UUID, MovementTrackingData>();
    private final DecimalFormat distanceFormat = new DecimalFormat("#.###");
    private BukkitTask detectionTask;

    public MovementDetectionManager(RexonRTP plugin) {
        this.plugin = plugin;
        this.initializeDetectionSystem();
    }

    private void initializeDetectionSystem() {
        if (!this.isMovementDetectionEnabled()) {
            return;
        }
        DetectionMethod method = this.getDetectionMethod();
        if (method == DetectionMethod.TASK || method == DetectionMethod.HYBRID) {
            this.startDetectionTask();
        }
    }

    public void startTracking(Player player, Location startLocation) {
        if (!this.isMovementDetectionEnabled()) {
            return;
        }
        MovementTrackingData data = new MovementTrackingData(startLocation.clone());
        this.trackedPlayers.put(player.getUniqueId(), data);
    }

    public void stopTracking(Player player) {
        this.trackedPlayers.remove(player.getUniqueId());
    }

    public boolean isTracking(Player player) {
        return this.trackedPlayers.containsKey(player.getUniqueId());
    }

    public void checkMovementFromEvent(Player player, Location from, Location to) {
        if (!this.isMovementDetectionEnabled()) {
            return;
        }
        DetectionMethod method = this.getDetectionMethod();
        if (method == DetectionMethod.TASK) {
            return;
        }
        this.processMovement(player, from, to, "EVENT");
    }

    private void checkMovementFromTask() {
        if (this.trackedPlayers.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, MovementTrackingData> entry : this.trackedPlayers.entrySet()) {
            UUID playerId = entry.getKey();
            Player player = this.plugin.getServer().getPlayer(playerId);
            if (player == null || !player.isOnline()) {
                this.trackedPlayers.remove(playerId);
                continue;
            }
            if (!this.plugin.getTeleportManager().isTeleporting(player)) {
                this.trackedPlayers.remove(playerId);
                continue;
            }
            this.processMovement(player, null, player.getLocation(), "TASK");
        }
    }

    private void processMovement(Player player, Location from, Location to, String source) {
        MovementTrackingData data = this.trackedPlayers.get(player.getUniqueId());
        if (data == null) {
            return;
        }
        if (player.hasPermission("rexonrtp.bypass")) {
            this.stopTracking(player);
            return;
        }
        Location originalLocation = data.startLocation;
        double threshold = this.getMovementThreshold();
        double deltaX = Math.abs(to.getX() - originalLocation.getX());
        double deltaY = Math.abs(to.getY() - originalLocation.getY());
        double deltaZ = Math.abs(to.getZ() - originalLocation.getZ());
        double distance = this.calculateDistance(deltaX, deltaY, deltaZ);
        data.lastKnownLocation = to.clone();
        data.maxDistanceMoved = Math.max(data.maxDistanceMoved, distance);
        ++data.totalChecks;
        if (distance > threshold) {
            this.handleMovementViolation(player, distance);
        }
    }

    private double calculateDistance(double deltaX, double deltaY, double deltaZ) {
        boolean detectHorizontal = this.plugin.getConfig().getBoolean("rtp.movement-detection.detect-horizontal", true);
        boolean detectVertical = this.plugin.getConfig().getBoolean("rtp.movement-detection.detect-vertical", true);
        double distance = 0.0;
        distance = detectHorizontal && detectVertical ? Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) : (detectHorizontal && !detectVertical ? Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) : (!detectHorizontal && detectVertical ? deltaY : Math.max(Math.max(deltaX, deltaY), deltaZ)));
        return distance;
    }

    private void handleMovementViolation(Player player, double distance) {
        this.stopTracking(player);
        this.plugin.getTeleportManager().cancelTeleportation(player);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("distance", this.distanceFormat.format(distance));
        placeholders.put("threshold", String.valueOf(this.getMovementThreshold()));
        String message = this.plugin.getConfigManager().getMessage("cancelled-moved", placeholders);
        player.sendMessage(message);
        try {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
        }
        catch (Exception e) {
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
        player.sendActionBar((Component)Component.text((String)(String.valueOf(ChatColor.RED) + "Teleportation cancelled - You moved!")));
    }

    private void startDetectionTask() {
        int interval = this.plugin.getConfig().getInt("rtp.movement-detection.check-interval", 1);
        this.detectionTask = new BukkitRunnable(){

            public void run() {
                MovementDetectionManager.this.checkMovementFromTask();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)interval);
    }

    private boolean isMovementDetectionEnabled() {
        return this.plugin.getConfig().getBoolean("rtp.movement-detection.enabled", true);
    }

    private DetectionMethod getDetectionMethod() {
        String methodName = this.plugin.getConfig().getString("rtp.movement-detection.method", "HYBRID").toUpperCase();
        try {
            return DetectionMethod.valueOf(methodName);
        }
        catch (IllegalArgumentException e) {
            return DetectionMethod.HYBRID;
        }
    }

    private double getMovementThreshold() {
        return this.plugin.getConfig().getDouble("rtp.movement-detection.threshold", 0.5);
    }

    public void cleanup() {
        if (this.detectionTask != null) {
            this.detectionTask.cancel();
        }
        this.trackedPlayers.clear();
    }

    public static enum DetectionMethod {
        EVENT,
        TASK,
        HYBRID;

    }

    public static class MovementTrackingData {
        final Location startLocation;
        Location lastKnownLocation;
        double maxDistanceMoved;
        int totalChecks;
        final long startTime;

        public MovementTrackingData(Location startLocation) {
            this.startLocation = startLocation.clone();
            this.lastKnownLocation = startLocation.clone();
            this.maxDistanceMoved = 0.0;
            this.totalChecks = 0;
            this.startTime = System.currentTimeMillis();
        }
    }
}

