/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.managers;

import com.rexon.rtp.RexonRTP;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SoundManager {
    private final RexonRTP plugin;

    public SoundManager(RexonRTP plugin) {
        this.plugin = plugin;
    }

    public void reloadSounds() {
    }

    public void playCountdownSound(Player player) {
        if (!this.plugin.getConfig().getBoolean("sounds.enabled", true)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("sounds.countdown.enabled", true)) {
            return;
        }
        try {
            String soundName = this.plugin.getConfig().getString("sounds.countdown.sound", "BLOCK_TRIPWIRE_CLICK_ON");
            Sound sound = Sound.valueOf((String)soundName);
            float volume = (float)this.plugin.getConfig().getDouble("sounds.countdown.volume", 1.0);
            float pitch = (float)this.plugin.getConfig().getDouble("sounds.countdown.pitch", 1.0);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid countdown sound configuration: " + e.getMessage());
        }
    }

    public void playTeleportSuccessSound(Player player) {
        if (!this.plugin.getConfig().getBoolean("sounds.enabled", true)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("sounds.teleport-success.enabled", true)) {
            return;
        }
        try {
            String soundName = this.plugin.getConfig().getString("sounds.teleport-success.sound", "ENTITY_ENDERMAN_TELEPORT");
            Sound sound = Sound.valueOf((String)soundName);
            float volume = (float)this.plugin.getConfig().getDouble("sounds.teleport-success.volume", 1.0);
            float pitch = (float)this.plugin.getConfig().getDouble("sounds.teleport-success.pitch", 1.0);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid teleport success sound configuration: " + e.getMessage());
        }
    }

    public void playTeleportCancelledSound(Player player) {
        if (!this.plugin.getConfig().getBoolean("sounds.enabled", true)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("sounds.teleport-cancelled.enabled", true)) {
            return;
        }
        try {
            String soundName = this.plugin.getConfig().getString("sounds.teleport-cancelled.sound", "BLOCK_NOTE_BLOCK_BASS");
            Sound sound = Sound.valueOf((String)soundName);
            float volume = (float)this.plugin.getConfig().getDouble("sounds.teleport-cancelled.volume", 1.0);
            float pitch = (float)this.plugin.getConfig().getDouble("sounds.teleport-cancelled.pitch", 1.0);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid teleport cancelled sound configuration: " + e.getMessage());
        }
    }

    public void playGUIClickSound(Player player) {
        if (!this.plugin.getConfig().getBoolean("sounds.enabled", true)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("sounds.gui-click.enabled", true)) {
            return;
        }
        try {
            String soundName = this.plugin.getConfig().getString("sounds.gui-click.sound", "UI_BUTTON_CLICK");
            Sound sound = Sound.valueOf((String)soundName);
            float volume = (float)this.plugin.getConfig().getDouble("sounds.gui-click.volume", 0.5);
            float pitch = (float)this.plugin.getConfig().getDouble("sounds.gui-click.pitch", 1.2);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid GUI click sound configuration: " + e.getMessage());
        }
    }
}

