/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.managers;

import com.rexon.rtp.RexonRTP;
import com.rexon.rtp.managers.ConfigManager;
import com.rexon.rtp.utils.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TeleportManager {
    private final RexonRTP plugin;
    private final Map<UUID, TeleportData> teleportingPlayers = new ConcurrentHashMap<UUID, TeleportData>();
    private final Map<UUID, Long> protectedPlayers = new ConcurrentHashMap<UUID, Long>();

    public TeleportManager(RexonRTP plugin) {
        this.plugin = plugin;
    }

    public void openRTPGUI(Player player) {
        try {
            if (!player.hasPermission("rexonrtp.bypass") && this.isTeleporting(player)) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("already-teleporting"));
                return;
            }
            String title = this.plugin.getConfigManager().getGUITitle();
            Inventory gui = Bukkit.createInventory(null, (int)27, (String)title);
            Map<String, ConfigManager.GUIItem> items = this.plugin.getConfigManager().getGUIItems();
            for (ConfigManager.GUIItem item : items.values()) {
                try {
                    ItemStack itemStack;
                    ItemMeta meta;
                    World world = WorldUtils.getWorldByNameOrAlias(item.world);
                    if (world == null || !this.plugin.getConfigManager().isWorldEnabled(item.world) || item.slot < 0 || item.slot >= 27 || (meta = (itemStack = new ItemStack(item.material)).getItemMeta()) == null) continue;
                    meta.displayName((Component)Component.text((String)item.name));
                    if (!item.lore.isEmpty()) {
                        ArrayList<TextComponent> loreComponents = new ArrayList<TextComponent>();
                        for (String loreLine : item.lore) {
                            loreComponents.add(Component.text((String)loreLine));
                        }
                        meta.lore(loreComponents);
                    }
                    itemStack.setItemMeta(meta);
                    gui.setItem(item.slot, itemStack);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error creating GUI item " + item.world + ": " + e.getMessage());
                }
            }
            player.openInventory(gui);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error opening RTP GUI: " + e.getMessage());
            player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while opening the RTP menu.");
        }
    }

    public void startRTPProcess(Player player, String worldInput) {
        try {
            if (!player.hasPermission("rexonrtp.bypass") && this.isTeleporting(player)) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("already-teleporting"));
                return;
            }
            World world = WorldUtils.getWorldByNameOrAlias(worldInput);
            if (world == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("world-not-found"));
                return;
            }
            String worldName = WorldUtils.getWorldDisplayName(world);
            if (!player.hasPermission("rexonrtp.bypass")) {
                this.plugin.getCooldownManager().setCooldown(player);
            }
            Location startLocation = player.getLocation().clone();
            int countdown = this.plugin.getConfigManager().getCountdownTime();
            TeleportData data = new TeleportData(startLocation, world, countdown);
            this.teleportingPlayers.put(player.getUniqueId(), data);
            this.plugin.getMovementDetectionManager().startTracking(player, startLocation);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("teleporting", placeholders));
            placeholders.put("time", String.valueOf(countdown));
            player.sendMessage(this.plugin.getConfigManager().getMessage("countdown", placeholders));
            player.sendActionBar((Component)Component.text((String)(String.valueOf(ChatColor.GRAY) + "Teleporting in " + ChatColor.translateAlternateColorCodes((char)'&', (String)("&d" + countdown + "s")))));
            this.plugin.getSoundManager().playCountdownSound(player);
            this.startCountdownTimer(player, data);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error starting RTP process for " + player.getName() + ": " + e.getMessage());
            player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while starting teleportation.");
            this.cleanupTeleportData(player);
        }
    }

    private void startCountdownTimer(final Player player, final TeleportData data) {
        data.countdownTask = new BukkitRunnable(this){
            final /* synthetic */ TeleportManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    if (!this.this$0.teleportingPlayers.containsKey(player.getUniqueId())) {
                        this.cancel();
                        return;
                    }
                    --data.countdown;
                    if (data.countdown > 0) {
                        player.sendActionBar((Component)Component.text((String)(String.valueOf(ChatColor.GRAY) + "Teleporting in " + ChatColor.translateAlternateColorCodes((char)'&', (String)("&d" + data.countdown + "s")))));
                        this.this$0.plugin.getSoundManager().playCountdownSound(player);
                    } else {
                        this.cancel();
                        this.this$0.plugin.getLocationSearchManager().searchLocationAsync(player, data.targetWorld);
                    }
                }
                catch (Exception e) {
                    this.this$0.plugin.getLogger().severe("Error in countdown task: " + e.getMessage());
                    this.this$0.cleanupTeleportData(player);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void teleportPlayerSafely(Player player, Location destination) {
        try {
            this.plugin.getMovementDetectionManager().stopTracking(player);
            player.teleport(destination);
            long protectionTime = this.plugin.getConfigManager().getProtectionTime();
            this.protectedPlayers.put(player.getUniqueId(), System.currentTimeMillis() + protectionTime);
            String worldName = WorldUtils.getWorldDisplayName(destination.getWorld());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("success", placeholders));
            player.sendActionBar((Component)Component.text((String)(String.valueOf(ChatColor.GREEN) + "Teleported to " + worldName + "!")));
            this.plugin.getSoundManager().playTeleportSuccessSound(player);
            this.cleanupTeleportData(player);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error teleporting player: " + e.getMessage());
            player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred during teleportation.");
            this.cleanupTeleportData(player);
        }
    }

    public void cancelTeleportation(Player player) {
        this.cleanupTeleportData(player);
    }

    public void cleanupTeleportData(Player player) {
        try {
            TeleportData data = this.teleportingPlayers.remove(player.getUniqueId());
            if (data != null && data.countdownTask != null) {
                data.countdownTask.cancel();
            }
            this.plugin.getMovementDetectionManager().stopTracking(player);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error cleaning up teleport data: " + e.getMessage());
        }
    }

    public boolean isTeleporting(Player player) {
        return this.teleportingPlayers.containsKey(player.getUniqueId());
    }

    public Location getTeleportStartLocation(Player player) {
        TeleportData data = this.teleportingPlayers.get(player.getUniqueId());
        return data != null ? data.startLocation.clone() : null;
    }

    public Location getStartLocation(Player player) {
        return this.getTeleportStartLocation(player);
    }

    public boolean isProtected(Player player) {
        Long protectionEnd = this.protectedPlayers.get(player.getUniqueId());
        if (protectionEnd == null) {
            return false;
        }
        if (System.currentTimeMillis() > protectionEnd) {
            this.protectedPlayers.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    public void cleanup() {
        try {
            this.teleportingPlayers.values().forEach(data -> {
                if (data.countdownTask != null) {
                    data.countdownTask.cancel();
                }
            });
            this.teleportingPlayers.clear();
            this.protectedPlayers.clear();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error during cleanup: " + e.getMessage());
        }
    }

    public Set<String> getAvailableWorlds() {
        HashSet<String> worlds = new HashSet<String>();
        try {
            Map<String, ConfigManager.GUIItem> items = this.plugin.getConfigManager().getGUIItems();
            for (ConfigManager.GUIItem item : items.values()) {
                if (WorldUtils.getWorldByNameOrAlias(item.world) == null) continue;
                worlds.add(item.world);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting available worlds: " + e.getMessage());
        }
        return worlds;
    }

    public static class TeleportData {
        final Location startLocation;
        final World targetWorld;
        int countdown;
        BukkitTask countdownTask;

        public TeleportData(Location startLocation, World targetWorld, int countdown) {
            this.startLocation = startLocation.clone();
            this.targetWorld = targetWorld;
            this.countdown = countdown;
        }
    }
}

