/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.utils;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LocationUtils {
    public static boolean isLocationSafe(Location location) {
        return LocationUtils.isLocationSafeEnhanced(location);
    }

    public static boolean isLocationSafeEnhanced(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        Block feet = world.getBlockAt(x, y, z);
        Block head = world.getBlockAt(x, y + 1, z);
        Block ground = world.getBlockAt(x, y - 1, z);
        if (!LocationUtils.isAir(feet) || !LocationUtils.isAir(head)) {
            return false;
        }
        if (LocationUtils.isAir(ground) || LocationUtils.isDangerous(ground.getType())) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Block checkGround = world.getBlockAt(x + dx, y - 1, z + dz);
                Block checkFeet = world.getBlockAt(x + dx, y, z + dz);
                Block checkHead = world.getBlockAt(x + dx, y + 1, z + dz);
                if (!LocationUtils.isDangerous(checkGround.getType()) && !LocationUtils.isDangerous(checkFeet.getType()) && !LocationUtils.isDangerous(checkHead.getType())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNetherLocationSafe(Location location) {
        return LocationUtils.isNetherLocationSafeEnhanced(location);
    }

    public static boolean isNetherLocationSafeEnhanced(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        Block feet = world.getBlockAt(x, y, z);
        Block head = world.getBlockAt(x, y + 1, z);
        Block ground = world.getBlockAt(x, y - 1, z);
        if (!LocationUtils.isAir(feet) || !LocationUtils.isAir(head)) {
            return false;
        }
        if (LocationUtils.isAir(ground) || ground.getType() == Material.LAVA) {
            return false;
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dy = -1; dy <= 2; ++dy) {
                    Block checkBlock = world.getBlockAt(x + dx, y + dy, z + dz);
                    if (checkBlock.getType() != Material.LAVA) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSurroundingAreaSafe(Location center, int radius) {
        World world = center.getWorld();
        if (world == null) {
            return false;
        }
        int centerX = center.getBlockX();
        int centerY = center.getBlockY();
        int centerZ = center.getBlockZ();
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                Block ground = world.getBlockAt(x, centerY - 1, z);
                Block feet = world.getBlockAt(x, centerY, z);
                Block head = world.getBlockAt(x, centerY + 1, z);
                if (LocationUtils.isDangerous(ground.getType()) || LocationUtils.isDangerous(feet.getType()) || LocationUtils.isDangerous(head.getType())) {
                    return false;
                }
                if (!LocationUtils.isAir(ground)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isAir(Block block) {
        Material type = block.getType();
        return type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR;
    }

    private static boolean isDangerous(Material material) {
        return material == Material.LAVA || material == Material.WATER || material == Material.MAGMA_BLOCK || material == Material.FIRE || material == Material.SOUL_FIRE || material == Material.CAMPFIRE || material == Material.SOUL_CAMPFIRE || material == Material.POWDER_SNOW || material == Material.SWEET_BERRY_BUSH || material == Material.WITHER_ROSE || material == Material.CACTUS || material == Material.POINTED_DRIPSTONE || material == Material.SCULK_SENSOR || material == Material.SCULK_SHRIEKER || material == Material.TNT || material == Material.END_PORTAL || material == Material.NETHER_PORTAL;
    }
}

