/*
 * Decompiled with CFR 0.152.
 */
package com.rexon.rtp.utils;

import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldUtils {
    public static World getWorldByNameOrAlias(String worldInput) {
        if (worldInput == null) {
            return null;
        }
        String input = worldInput.toLowerCase();
        World world = Bukkit.getWorld((String)worldInput);
        if (world != null) {
            return world;
        }
        switch (input) {
            case "overworld": {
                return Bukkit.getWorld((String)"world");
            }
            case "nether": {
                return Bukkit.getWorld((String)"world_nether");
            }
            case "end": {
                return Bukkit.getWorld((String)"world_the_end");
            }
        }
        for (World w : Bukkit.getWorlds()) {
            if (!w.getName().equalsIgnoreCase(worldInput)) continue;
            return w;
        }
        return null;
    }

    public static String getWorldDisplayName(World world) {
        if (world == null) {
            return "Unknown";
        }
        String worldName = world.getName();
        switch (worldName.toLowerCase()) {
            case "world": {
                return "Overworld";
            }
            case "world_nether": {
                return "Nether";
            }
            case "world_the_end": {
                return "End";
            }
        }
        return worldName;
    }
}

