package toni.lib.animation;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import toni.lib.animation.easing.EasingType;
import toni.lib.animation.effects.IAnimationEffect;
import F;
import java.util.function.Function;

public class AnimationEffect implements IAnimationEffect {

    @Getter @Setter
    public float in;
    @Getter @Setter
    public float out;

    @Getter @Setter
    public float intensity;
    @Getter @Setter
    public float speed;

    public Type type;

    public AnimationEffect(float in, float out, float intensity, float speed, Type type) {
        this.in = in;
        this.out = out;
        this.type = type;
        this.intensity = intensity;
        this.speed = speed;
    }

    public void encode(class_2540 buf) {
        buf.method_52941(in);
        buf.method_52941(out);
        buf.method_52941(intensity);
        buf.method_52941(speed);
        buf.method_10817(type);
    }

    public static AnimationEffect decode(class_2540 buf) {
        var in = buf.readFloat();
        var out = buf.readFloat();
        var intensity = buf.readFloat();
        var speed = buf.readFloat();
        var type = buf.method_10818(Type.class);

        return new AnimationEffect(in, out, intensity, speed, type);
    }

    public enum Type implements IAnimationFunction {
        WAVE {
            @Override
            public float calculate(AnimationEffect effect, float time) {
                return effect.intensity * class_3532.method_15362(effect.speed * time);
            }
        }
    }
}