package toni.lib.animation;

import F;
import net.minecraft.class_332;
import org.joml.Quaternionf;

public class PoseUtils {

    public static void applyScale(class_332 context, float scale) {
        context.method_51448().method_46416(context.method_51421() / scale, context.method_51443() / scale,0f);
        context.method_51448().method_22905(scale, scale, scale);
        context.method_51448().method_46416(context.method_51421() / (-scale * scale), context.method_51443() / (-scale * scale),0f);
    }

    public static void applyYRotation(class_332 context, float scale, float objectWidth, float objectHeight, float rotY) {
        float d2r = (float) Math.PI / 180;
        var quat = new Quaternionf().rotationXYZ(0 * d2r, rotY * d2r, 0 * d2r);

        var width = objectWidth / 2f;
        var height = objectHeight / 2f;

        context.method_51448().method_46416(width, height, 0);
        context.method_51448().method_22907(quat);
        context.method_51448().method_46416(-width, -height, 0);
    }

    public static void applyXRotation(class_332 context, float scale, float objectWidth, float objectHeight, float rotX) {
        float d2r = (float) Math.PI / 180;
        var quat = new Quaternionf().rotationXYZ(rotX * d2r, d2r, 0 * d2r);

        var width = objectWidth / 2f;
        var height = objectHeight / 2f;

        context.method_51448().method_46416(width, height, 0);
        context.method_51448().method_22907(quat);
        context.method_51448().method_46416(-width, -height, 0);
    }

    public static void applyZRotation(class_332 context, float scale, float objectWidth, float objectHeight, float rotX) {
        float d2r = (float) Math.PI / 180;
        var quat = new Quaternionf().rotationXYZ(0 * d2r, d2r, rotX * d2r);

        var width = objectWidth / 2f;
        var height = objectHeight / 2f;

        context.method_51448().method_46416(width, height, 0);
        context.method_51448().method_22907(quat);
        context.method_51448().method_46416(-width, -height, 0);
    }

    public static void applyPosition(class_332 context, float scale, float objectWidth, float objectHeight, float posX, float posY, float posZ) {
        var centerX = (posX / scale) + (context.method_51421() - (objectWidth * scale)) / (2f * scale);
        var centerY = (posY / scale) + (context.method_51443() - (objectHeight * scale)) / (2f * scale);

        context.method_51448().method_46416(centerX, centerY, posZ);
    }
}
