package toni.lib.animation;

import D;
import F;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import toni.lib.animation.easing.EasingFunctionArgs;
import toni.lib.animation.easing.EasingManager;
import toni.lib.animation.easing.EasingType;
import toni.lib.animation.effects.IAnimationEffect;
import toni.lib.utils.ColorUtils;

import java.util.ArrayList;
import java.util.List;

public class Transition implements IAnimationEffect {

    private AnimationTimeline parent;

    @Getter @Setter
    private float in;
    @Getter @Setter
    private float out;

    @Getter @Setter
    private float startValue;
    @Getter @Setter
    private float endValue;

    private EasingType easingFunctionTypeCache;
    private Double easingFunctionArgCache;

    private Double2DoubleFunction easingFunction;

    public void encode(class_2540 buf) {
        buf.method_52941(in);
        buf.method_52941(out);
        buf.method_52941(startValue);
        buf.method_52941(endValue);

        buf.method_10817(easingFunctionTypeCache);
        buf.method_52940(easingFunctionArgCache);
    }

    public static Transition decode(class_2540 buf) {

        var in = buf.readFloat();
        var out = buf.readFloat();
        var startValue = buf.readFloat();
        var endValue = buf.readFloat();

        var easingFunctionTypeCache = buf.method_10818(EasingType.class);
        var easingFunctionArgCache = buf.readDouble();

        return new Transition(in, out, easingFunctionTypeCache, startValue, endValue, easingFunctionArgCache);
    }

    public Transition(float in, float out, EasingType easing, float start, float end) {
        this.in = in;
        this.out = out;
        this.startValue = start;
        this.endValue = end;

        easingFunctionTypeCache = easing;
        easingFunctionArgCache = 1.0d;

        easingFunction = EasingManager.getEasingFunction.apply(new EasingFunctionArgs(easing, null));
    }

    public Transition(float in, float out, EasingType easing, float start, float end, double elasticity) {
        this.in = in;
        this.out = out;
        this.startValue = start;
        this.endValue = end;

        easingFunctionTypeCache = easing;
        easingFunctionArgCache = elasticity;

        easingFunction = EasingManager.getEasingFunction.apply(new EasingFunctionArgs(easing, elasticity));
    }

    public float eval(Binding binding, float current) {
        var lerp = class_3532.method_15350((double) (current - in) / (out - in), 0f, 1f);
        lerp = easingFunction.apply(lerp);

        lerp = class_3532.method_15350(lerp, 0, 1f);

        if (binding == Binding.Color)
            return ColorUtils.lerp((float) lerp, (int) startValue, (int) endValue);

        return (float) class_3532.method_16436(lerp, startValue, endValue);
    }


}

