package toni.lib.modifiers;

import toni.lib.utils.VersionUtils;

import java.util.UUID;
import net.minecraft.class_1324;
import net.minecraft.class_2960;

public class ModifierDefinition
{
    private static String ID;
    #if AFTER_21_1
    private static class_2960 Resource;
    #else
    private static UUID Resource;
    #endif

    public ModifierDefinition(String modid, String path)
    {
        ID = path;

        #if AFTER_21_1
        Resource = VersionUtils.resource(modid, path);
        #else
        Resource = Mth.createInsecureUUID(RandomSource.create(path.hashCode()));
        #endif
    }

    public void removeModifier(class_1324 attribute) {
        attribute.method_6200(Resource);
    }

    public void addPermanentModifier(class_1324 attribute, double value) {
        attribute.addPermanentModifier(new AttributeModifier(
            Resource,
            #if BEFORE_21_1 ID, #endif
            value,
            #if BEFORE_21_1 AttributeModifier.Operation.ADDITION #else AttributeModifier.Operation.ADD_VALUE #endif));
    }


}
