package toni.lib.networking;


import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import toni.lib.utils.VersionUtils;
import Type;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
#else
    import toni.lib.networking.codecs.StreamCodec;
#endif

public abstract class ToniPacket <TPacket extends ToniPacket> #if AFTER_21_1 implements CustomPacketPayload #endif
{
    public class_2960 Resource;
    public class_9139<class_2540, TPacket> CODEC;

    #if AFTER_21_1
    public class_8710.class_9154<TPacket> ID;

    @Override public Type<? extends class_8710> type() { return ID; }
    #endif


    public ToniPacket(String modid, String path, class_9139<class_2540, TPacket> codec) {
        Resource = VersionUtils.resource(modid, path);
        CODEC = codec; //StreamCodec.composite(ByteBufCodecs.BOOL, SyncMediumcoreGameRuleMessage::mediumcoreMode, SyncMediumcoreGameRuleMessage::new);

        #if AFTER_21_1
        ID = new CustomPacketPayload.Type<>(Resource);
        #endif
    }

    public void registerType()
    {
        #if AFTER_21_1
        // In your common initializer method
        PayloadTypeRegistry.playS2C().register(ID, CODEC);
        #endif
    }

    public void registerClientHandler(BiConsumer<TPacket, class_746> consumer)
    {
        #if AFTER_21_1
        ClientPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> consumer.accept(payload, context.player()));
        #else
        ClientPlayNetworking.registerGlobalReceiver(Resource, (client, handler, buf, responseSender) ->
        {
            var packet = CODEC.decode(buf);
            consumer.accept(packet, client.player);
        });
        #endif
    }

    public void registerClientHandler(Consumer<TPacket> consumer)
    {
        #if AFTER_21_1
        ClientPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> consumer.accept(payload));
        #else
        ClientPlayNetworking.registerGlobalReceiver(Resource, (client, handler, buf, responseSender) ->
        {
            var packet = CODEC.decode(buf);
            consumer.accept(packet);
        });
        #endif
    }

    public void sendToAll(MinecraftServer server)
    {
        #if BEFORE_21_1
        FriendlyByteBuf buf = PacketByteBufs.create();
        CODEC.encode(buf, (TPacket) this);
        #endif

        for (ServerPlayer player : server.getPlayerList().getPlayers())
        {
            #if AFTER_21_1
            ServerPlayNetworking.send(player, this);
            #else
            ServerPlayNetworking.send(player, Resource, buf);
            #endif
        }
    }

    public void send(class_3222 player)
    {
        #if AFTER_21_1
        ServerPlayNetworking.send(player, this);
        #else
        FriendlyByteBuf buf = PacketByteBufs.create();
        CODEC.encode(buf, (TPacket) this);
        ServerPlayNetworking.send(player, Resource, buf);
        #endif
    }
}
