/*
 * Decompiled with CFR 0.152.
 */
package dev.neovoxel.lc.util;

import dev.neovoxel.lc.config.ModConfig;
import dev.neovoxel.lc.util.ClipboardActionUtil;
import dev.neovoxel.lc.util.EscapeUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class RecordActionUtil {
    private final class_746 player;
    private final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture future;
    private final StringBuilder stringBuilder = new StringBuilder();
    private static final Logger logger = LoggerFactory.getLogger((String)"location-clipboard");

    public RecordActionUtil(class_746 player) {
        this.player = player;
    }

    public void start() {
        this.future = executor.scheduleAtFixedRate(() -> this.record(false), 0L, this.config.record.autoRecordPeriod, TimeUnit.SECONDS);
        if (this.config.message.basic) {
            this.player.method_7353((class_2561)class_2561.method_43471((String)"text.location-clipboard.message.record-start"), false);
        }
        if (this.config.message.logBasic) {
            logger.info("Player started recording");
        }
    }

    public void record(boolean isPlayerExecuted) {
        if (isPlayerExecuted) {
            ClipboardActionUtil util;
            String content;
            if ((!this.config.record.autoRecord || this.config.record.autoRecordAndSelfRecord) && (content = (util = new ClipboardActionUtil(this.player)).copyContent()) != null) {
                if (this.config.message.advanced) {
                    this.player.method_7353(class_2561.method_30163((String)class_2561.method_43471((String)"text.location-clipboard.message.record").getString().replace("${content}", content)), false);
                }
                if (this.config.message.logAdvanced) {
                    logger.debug("Recorded by player: {}", (Object)content);
                }
                this.stringBuilder.append(content).append(this.config.record.separator);
            }
        } else {
            ClipboardActionUtil util = new ClipboardActionUtil(this.player);
            String content = util.copyContent();
            if (this.config.record.copyWithRecord) {
                class_310.method_1551().field_1774.method_1455(content);
            }
            if (content != null) {
                if (this.config.message.advanced) {
                    this.player.method_7353(class_2561.method_30163((String)class_2561.method_43471((String)"text.location-clipboard.message.auto-record").getString().replace("${content}", content)), false);
                }
                if (this.config.message.logAdvanced) {
                    logger.debug("Recorded automatically: {}", (Object)content);
                }
                this.stringBuilder.append(content).append(this.config.record.separator);
            }
        }
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.stringBuilder.isEmpty()) {
            return;
        }
        String content = this.stringBuilder.substring(0, this.stringBuilder.length() - this.config.record.separator.length());
        if (this.config.general.replaceEscapeChar) {
            content = EscapeUtil.unescapeAll(content);
        }
        class_310.method_1551().field_1774.method_1455(content);
        if (this.config.message.basic) {
            this.player.method_7353(class_2561.method_30163((String)class_2561.method_43471((String)"text.location-clipboard.message.record-stop").getString().replace("${content}", content)), false);
        }
        if (this.config.message.logBasic) {
            logger.info("Player stopped recording, the final result is {}", (Object)content);
        }
    }
}

