/*
 * Decompiled with CFR 0.152.
 */
package dev.neovoxel.lc.util;

import dev.neovoxel.lc.LocationClipboardClient;
import dev.neovoxel.lc.config.ModConfig;
import dev.neovoxel.lc.type.PositionType;
import dev.neovoxel.lc.util.EscapeUtil;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ClipboardActionUtil {
    private final class_746 player;
    private final class_310 client = class_310.method_1551();
    private final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();

    public ClipboardActionUtil(class_746 player) {
        this.player = player;
    }

    public String copyContent() {
        if (this.config.general.positionType == PositionType.PLAYER) {
            return this.copyPlayerLocation();
        }
        if (this.config.general.positionType == PositionType.UNDERFOOT_BLOCK) {
            return this.copyUnderfootBlock();
        }
        if (this.config.general.positionType == PositionType.TARGETED_BLOCK) {
            return this.copyTargetedBlock(true);
        }
        if (this.config.general.positionType == PositionType.TARGETED_BLOCK_WITHOUT_FLUID) {
            return this.copyTargetedBlock(false);
        }
        return null;
    }

    public void copy() {
        if (LocationClipboardClient.recordActionUtil != null) {
            LocationClipboardClient.recordActionUtil.record(true);
            return;
        }
        String content = null;
        if (this.config.general.positionType == PositionType.PLAYER) {
            content = this.copyPlayerLocation();
        } else if (this.config.general.positionType == PositionType.UNDERFOOT_BLOCK) {
            content = this.copyUnderfootBlock();
        } else if (this.config.general.positionType == PositionType.TARGETED_BLOCK) {
            content = this.copyTargetedBlock(true);
        } else if (this.config.general.positionType == PositionType.TARGETED_BLOCK_WITHOUT_FLUID) {
            content = this.copyTargetedBlock(false);
        }
        if (content != null) {
            this.client.field_1774.method_1455(content);
            if (this.config.message.logBasic) {
                Log.info((LogCategory)LogCategory.LOG, (String)("Player copy the position content: " + content));
            }
            if (this.config.message.basic) {
                this.client.field_1724.method_7353(class_2561.method_30163((String)new class_2588("text.location-clipboard.message.copy").getString().replace("${content}", content)), false);
            }
        }
    }

    public String copyPlayerLocation() {
        String name = this.player.method_5477().getString();
        double x = this.player.method_23317();
        double y = this.player.method_23318();
        double z = this.player.method_23321();
        double pitch = this.player.method_5695(1.0f);
        double yaw = this.player.method_5705(1.0f);
        String content = this.config.general.format.replace("${player}", name).replace("${x}", String.format("%." + this.config.data.xPrecision + "f", x)).replace("${y}", String.format("%." + this.config.data.yPrecision + "f", y)).replace("${z}", String.format("%." + this.config.data.zPrecision + "f", z)).replace("${pitch}", String.format("%." + this.config.data.pitchPrecision + "f", pitch)).replace("${yaw}", String.format("%." + this.config.data.yawPrecision + "f", yaw));
        if (this.config.general.replaceEscapeChar) {
            content = EscapeUtil.unescapeAll(content);
        }
        return content;
    }

    public String copyUnderfootBlock() {
        class_2338 pos = this.player.method_24515();
        int x = pos.method_10263();
        int y = pos.method_10264() - 1;
        int z = pos.method_10260();
        String content = this.config.general.format.replace("${player}", this.player.method_5477().getString()).replace("${x}", String.valueOf(x)).replace("${y}", String.valueOf(y)).replace("${z}", String.valueOf(z));
        if (this.config.general.replaceEscapeChar) {
            content = EscapeUtil.unescapeAll(content);
        }
        return content;
    }

    public String copyTargetedBlock(boolean withFluid) {
        class_243 pos = this.player.method_5745((double)this.config.general.targetedMaxDistance, 0.0f, withFluid).method_17784();
        double x = pos.method_10216();
        double y = pos.method_10214();
        double z = pos.method_10215();
        String content = this.config.general.format.replace("${player}", this.player.method_5477().getString()).replace("${x}", String.format("%." + this.config.data.xPrecision + "f", x)).replace("${y}", String.format("%." + this.config.data.yPrecision + "f", y)).replace("${z}", String.format("%." + this.config.data.zPrecision + "f", z));
        if (this.config.general.replaceEscapeChar) {
            content = EscapeUtil.unescapeAll(content);
        }
        return content;
    }
}

