/*
 * Decompiled with CFR 0.152.
 */
package dev.neovoxel.lc.util;

import dev.neovoxel.lc.config.ModConfig;
import dev.neovoxel.lc.util.ClipboardActionUtil;
import dev.neovoxel.lc.util.EscapeUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class RecordActionUtil {
    private final class_746 player;
    private final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture future;
    private final StringBuilder stringBuilder = new StringBuilder();

    public RecordActionUtil(class_746 player) {
        this.player = player;
    }

    public void start() {
        this.future = executor.scheduleAtFixedRate(() -> this.record(false), 0L, this.config.record.autoRecordPeriod, TimeUnit.SECONDS);
        if (this.config.message.basic) {
            this.player.method_7353((class_2561)new class_2588("text.location-clipboard.message.record-start"), false);
        }
        if (this.config.message.logBasic) {
            Log.info((LogCategory)LogCategory.LOG, (String)"Player started recording");
        }
    }

    public void record(boolean isPlayerExecuted) {
        if (isPlayerExecuted) {
            ClipboardActionUtil util;
            String content;
            if ((!this.config.record.autoRecord || this.config.record.autoRecordAndSelfRecord) && (content = (util = new ClipboardActionUtil(this.player)).copyContent()) != null) {
                if (this.config.message.advanced) {
                    this.player.method_7353(class_2561.method_30163((String)new class_2588("text.location-clipboard.message.record").getString().replace("${content}", content)), false);
                }
                if (this.config.message.logAdvanced) {
                    Log.debug((LogCategory)LogCategory.LOG, (String)("Recorded by player: " + content));
                }
                this.stringBuilder.append(content).append(this.config.record.separator);
            }
        } else {
            ClipboardActionUtil util = new ClipboardActionUtil(this.player);
            String content = util.copyContent();
            if (this.config.record.copyWithRecord) {
                class_310.method_1551().field_1774.method_1455(content);
            }
            if (content != null) {
                if (this.config.message.advanced) {
                    this.player.method_7353(class_2561.method_30163((String)new class_2588("text.location-clipboard.message.auto-record").getString().replace("${content}", content)), false);
                }
                if (this.config.message.logAdvanced) {
                    Log.debug((LogCategory)LogCategory.LOG, (String)("Recorded automatically: " + content));
                }
                this.stringBuilder.append(content).append(this.config.record.separator);
            }
        }
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.stringBuilder.isEmpty()) {
            return;
        }
        String content = this.stringBuilder.substring(0, this.stringBuilder.length() - this.config.record.separator.length());
        if (this.config.general.replaceEscapeChar) {
            content = EscapeUtil.unescapeAll(content);
        }
        class_310.method_1551().field_1774.method_1455(content);
        if (this.config.message.basic) {
            this.player.method_7353(class_2561.method_30163((String)new class_2588("text.location-clipboard.message.record-stop").getString().replace("${content}", content)), false);
        }
        if (this.config.message.logBasic) {
            Log.info((LogCategory)LogCategory.LOG, (String)("Player stopped recording, the final result is " + content));
        }
    }
}

