package archives.tater.netherarchives.mixin;

import archives.tater.netherarchives.duck.AirSkiier;
import archives.tater.netherarchives.item.SkisItem;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_8080;
import net.minecraft.world.entity.*;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements AirSkiier {
    @Shadow @Final public class_8080 walkAnimation;

    @Shadow public abstract boolean isFallFlying();

    @Shadow
    public abstract class_1799 getItemBySlot(class_1304 slot);

    @Shadow
    public abstract float getSpeed();

    @Unique
    private boolean netherarchives$isAirSkiing = false;

    @Unique
    private int netherarchives$ticksSkiing = 0;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(
            method = "canStandOnFluid",
            at = @At("HEAD"),
            cancellable = true)
    private void checkBasaltSkis(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        if (SkisItem.canSki((class_1309) (Object) this, state) && method_5861(class_3486.field_15517) <= SkisItem.MAX_FLUID_DEPTH && method_5861(class_3486.field_15518) <= SkisItem.MAX_FLUID_DEPTH)
            cir.setReturnValue(true);
    }

    @SuppressWarnings("DataFlowIssue")
    @ModifyExpressionValue(
            method = "travel",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;getFriction()F")
    )
    private float skiFriction(float original, @Local class_3610 fluidState, @Share("isSkiing") LocalBooleanRef isSkiing) {
        isSkiing.set(SkisItem.canSki((class_1309) (Object) this, fluidState));

        return isSkiing.get() ? 1.08f : original;
        // Air drag is 0.91
    }

    @WrapOperation(
            method = "travel",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;calculateEntityAnimation(Z)V")
    )
    private void damageSkisAndNoSkiLimbs(class_1309 instance, boolean flutter, Operation<Void> original, @Share("isSkiing") LocalBooleanRef isSkiing) {
        if (!method_37908().field_9236 && (isSkiing.get() || netherarchives$isAirSkiing) && method_18798().method_1033() > SkisItem.MIN_DAMAGE_VELOCITY) {
            netherarchives$ticksSkiing += 1;
            if (netherarchives$ticksSkiing >= SkisItem.DAMAGE_FREQUENCY) {
                getItemBySlot(class_1304.field_6166).method_7970(1, (class_1309) (Object) this, class_1304.field_6166);
                netherarchives$ticksSkiing = 0;
            }
        }

        if (!isSkiing.get() && !SkisItem.isSkiing(instance) && !netherarchives$isAirSkiing) {
            original.call(instance, flutter);
            return;
        }

        walkAnimation.method_48568(0, 0.4f);
    }

    @ModifyReturnValue(
            method = "getFrictionInfluencedSpeed",
            at = @At("RETURN")
    )
    private float preventMovementOnSkis(float original) {
        if (SkisItem.isSkiing((class_1309) (Object) this)) return 0.0f;
        return original;
    }

    @ModifyExpressionValue(
            method = "getFrictionInfluencedSpeed",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;getFlyingSpeed()F")
    )
    private float increasedAirSkiMovement(float original) {
        return netherarchives$isAirSkiing ? 0.35f * getSpeed() : original;
    }

    @Inject(
            method = "jumpFromGround",
            at = @At("HEAD"),
            cancellable = true)
    private void preventJumpOnSkis(CallbackInfo ci) {
        if (SkisItem.isSkiing((class_1309) (Object) this)) ci.cancel();
    }

    @Override
    public boolean netherarchives$isAirSkiing() {
        return netherarchives$isAirSkiing;
    }

    @Override
    public void netherarchives$setAirSkiing(boolean airSkiing) {
        netherarchives$isAirSkiing = airSkiing;
    }

    @ModifyVariable(
            method = "travel",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal = 0)
    )
    private double slowFallingWhileAirSkiing(double original) {
        return netherarchives$isAirSkiing && !method_5715() ? 0.01 : original;
    }

    @Inject(
            method = "travel",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")
    )
    private void stopAirSkiing(class_243 movementInput, CallbackInfo ci) {
        //noinspection ConstantValue
        if (this.method_5799() || this.method_5771() || this.isFallFlying() || ((Object) this instanceof class_1657 playerEntity && playerEntity.method_31549().field_7479))
            netherarchives$isAirSkiing = false;
    }

    @ModifyExpressionValue(
            method = "checkFallDamage",
            at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/LivingEntity;fallDistance:F", ordinal = 1, opcode = Opcodes.GETFIELD)
    )
    private float noFallDamageWhileAirSkiing(float original) {
        if (!netherarchives$isAirSkiing) return original;
        return 0f;
    }

    @WrapWithCondition(
            method = "checkFallDamage",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;checkFallDamage(DZLnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)V")
    )
    private boolean noFallDamageWhileAirSkiing(class_1297 instance, double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        if (!onGround || !netherarchives$isAirSkiing) return true;
        netherarchives$isAirSkiing = false;
        method_38785();
        return false;
    }
}
