package archives.tater.netherarchives.mixin;

import archives.tater.netherarchives.item.SkisItem;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2248.class)
public class BlockMixin {
    // I think this is bettern than adding an override in FluidBlock?
    @Inject(
            method = "fallOn",
            at = @At("HEAD"),
            cancellable = true)
    private void preventFallOnSkis(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance, CallbackInfo ci) {
        //noinspection ConstantValue
        if (!((Object) this instanceof class_2404)) return;
        if (!(entity instanceof class_1309 livingEntity) || !SkisItem.canSki(livingEntity, state.method_26227())) return;
        entity.method_5747(fallDistance, 0.0F, world.method_48963().method_48827());
        ci.cancel();
    }
}
