/*
 * Decompiled with CFR 0.152.
 */
package net.leebyte.remonitor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_313;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

public class ReMonitorClient
implements ClientModInitializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("remonitor.json");

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(ReMonitorClient::loadCurrentMonitor);
        ClientLifecycleEvents.CLIENT_STOPPING.register(ReMonitorClient::saveCurrentMonitor);
    }

    private static void loadCurrentMonitor(class_310 client) {
        Config config = ReMonitorClient.load();
        if (config == null) {
            return;
        }
        class_1041 window = client.method_22683();
        long targetMonitor = ReMonitorClient.findMonitor(config);
        if (targetMonitor == 0L) {
            return;
        }
        boolean wasFullscreenAtStart = window.method_4498();
        if (wasFullscreenAtStart) {
            window.method_4500();
        }
        ReMonitorClient.centerWindowOnMonitor(targetMonitor, window.method_4490());
        if (config.fullscreen && !window.method_4498()) {
            window.method_4500();
        }
    }

    private static void saveCurrentMonitor(class_310 client) {
        try {
            class_1041 window = client.method_22683();
            Config config = new Config();
            config.fullscreen = window.method_4498();
            class_313 mon = window.method_20831();
            long monitorPtr = 0L;
            if (mon != null) {
                monitorPtr = mon.method_1622();
            }
            config.monitorIndex = ReMonitorClient.indexOfMonitor(monitorPtr);
            try (BufferedWriter w = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Config load() {
        Config config;
        block9: {
            if (!Files.isRegularFile(CONFIG_PATH, new LinkOption[0])) {
                return null;
            }
            BufferedReader r = Files.newBufferedReader(CONFIG_PATH);
            try {
                config = (Config)GSON.fromJson((Reader)r, Config.class);
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            r.close();
        }
        return config;
    }

    private static long findMonitor(Config config) {
        long m;
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        if (monitors == null || monitors.limit() == 0) {
            return 0L;
        }
        if (config.monitorIndex >= 0L && config.monitorIndex < (long)monitors.limit() && (m = monitors.get((int)config.monitorIndex)) != 0L) {
            return m;
        }
        long primary = GLFW.glfwGetPrimaryMonitor();
        if (primary != 0L) {
            return primary;
        }
        return monitors.get(0);
    }

    private static long indexOfMonitor(long monitorPtr) {
        if (monitorPtr == 0L) {
            return -1L;
        }
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        if (monitors == null) {
            return -1L;
        }
        for (int i = 0; i < monitors.limit(); ++i) {
            if (monitors.get(i) != monitorPtr) continue;
            return i;
        }
        return -1L;
    }

    private static void centerWindowOnMonitor(long monitor, long windowHandle) {
        if (monitor == 0L || windowHandle == 0L) {
            return;
        }
        int[] mx = new int[1];
        int[] my = new int[1];
        GLFW.glfwGetMonitorPos((long)monitor, (int[])mx, (int[])my);
        GLFWVidMode mode = GLFW.glfwGetVideoMode((long)monitor);
        if (mode == null) {
            return;
        }
        int monitorW = mode.width();
        int monitorH = mode.height();
        int[] ww = new int[1];
        int[] wh = new int[1];
        GLFW.glfwGetWindowSize((long)windowHandle, (int[])ww, (int[])wh);
        int nx = mx[0] + Math.max(0, (monitorW - ww[0]) / 2);
        int ny = my[0] + Math.max(0, (monitorH - wh[0]) / 2);
        GLFW.glfwSetWindowPos((long)windowHandle, (int)nx, (int)ny);
    }

    private static class Config {
        long monitorIndex = -1L;
        boolean fullscreen = false;

        private Config() {
        }
    }
}

