/*
 * Decompiled with CFR 0.152.
 */
package client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FavoritesManager {
    private static final Path FAVORITES_PATH = Paths.get(Minecraft.getInstance().gameDirectory.getAbsolutePath(), "config", "JEBfavorites.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Set<ResourceLocation> loadFavoriteItemIds() {
        HashSet<ResourceLocation> result = new HashSet<ResourceLocation>();
        try {
            if (!Files.exists(FAVORITES_PATH, new LinkOption[0])) {
                return result;
            }
            JsonArray array = (JsonArray)GSON.fromJson((Reader)Files.newBufferedReader(FAVORITES_PATH), JsonArray.class);
            String server = FavoritesManager.getServerName();
            for (JsonElement el : array) {
                JsonObject obj = el.getAsJsonObject();
                if (!server.equals(obj.get("server").getAsString())) continue;
                result.add(ResourceLocation.bySeparator((String)obj.get("item").getAsString(), (char)':'));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void removeFavorite(ItemStack stack) {
        try {
            String server = FavoritesManager.getServerName();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            String nbtString = FavoritesManager.getSerializedNbt(stack);
            if (!Files.exists(FAVORITES_PATH, new LinkOption[0])) {
                return;
            }
            JsonArray favorites = (JsonArray)GSON.fromJson((Reader)Files.newBufferedReader(FAVORITES_PATH), JsonArray.class);
            JsonArray newFavorites = new JsonArray();
            boolean removed = false;
            for (JsonElement element : favorites) {
                JsonObject obj = element.getAsJsonObject();
                boolean sameServer = server.equals(obj.get("server").getAsString());
                boolean sameItem = itemId.toString().equals(obj.get("item").getAsString());
                String nbtInFile = obj.has("nbt") ? obj.get("nbt").getAsString() : "";
                boolean sameNbt = nbtString.equals(nbtInFile);
                if (sameServer && sameItem && sameNbt && !removed) {
                    removed = true;
                    continue;
                }
                newFavorites.add((JsonElement)obj);
            }
            Files.createDirectories(FAVORITES_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(FAVORITES_PATH.toFile());){
                GSON.toJson((JsonElement)newFavorites, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveFavorite(ItemStack stack) {
        block9: {
            try {
                String server = FavoritesManager.getServerName();
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                String nbtString = FavoritesManager.getSerializedNbt(stack);
                JsonArray favorites = Files.exists(FAVORITES_PATH, new LinkOption[0]) ? (JsonArray)GSON.fromJson((Reader)Files.newBufferedReader(FAVORITES_PATH), JsonArray.class) : new JsonArray();
                boolean alreadyExists = false;
                for (JsonElement element : favorites) {
                    JsonObject obj = element.getAsJsonObject();
                    boolean sameServer = server.equals(obj.get("server").getAsString());
                    boolean sameItem = itemId.toString().equals(obj.get("item").getAsString());
                    String nbtInFile = obj.has("nbt") ? obj.get("nbt").getAsString() : "";
                    boolean sameNbt = nbtString.equals(nbtInFile);
                    if (!sameItem || !sameServer || !sameNbt) continue;
                    alreadyExists = true;
                    break;
                }
                if (alreadyExists) break block9;
                JsonObject favoriteEntry = new JsonObject();
                favoriteEntry.addProperty("server", server);
                favoriteEntry.addProperty("item", itemId.toString());
                if (!nbtString.isEmpty()) {
                    favoriteEntry.addProperty("nbt", nbtString);
                }
                favorites.add((JsonElement)favoriteEntry);
                favorites = FavoritesManager.sortFavorites(favorites);
                Files.createDirectories(FAVORITES_PATH.getParent(), new FileAttribute[0]);
                try (FileWriter writer = new FileWriter(FAVORITES_PATH.toFile());){
                    GSON.toJson((JsonElement)favorites, (Appendable)writer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static JsonArray sortFavorites(JsonArray favorites) {
        List<JsonObject> sortedList = favorites.asList().stream().map(JsonElement::getAsJsonObject).sorted(Comparator.comparing(o -> o.get("server").getAsString()).thenComparing(o -> o.get("item").getAsString())).toList();
        JsonArray sortedArray = new JsonArray();
        for (JsonObject obj : sortedList) {
            sortedArray.add((JsonElement)obj);
        }
        return sortedArray;
    }

    private static String getServerName() {
        Minecraft client = Minecraft.getInstance();
        if (client.getCurrentServer() != null) {
            return client.getCurrentServer().ip;
        }
        if (client.getSingleplayerServer() != null) {
            return client.getSingleplayerServer().getWorldData().getLevelName();
        }
        return "unknown_local_world";
    }

    private static String getSerializedNbt(ItemStack stack) {
        return "";
    }
}

