/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.JebClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.crafting.display.StonecutterRecipeDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeLoader {
    private static List<String> parseBracketedList(String input) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int bracketLevel = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ',' && bracketLevel == 0) {
                result.add(current.toString().trim());
                current.setLength(0);
                continue;
            }
            if (c == '[') {
                ++bracketLevel;
            } else if (c == ']') {
                --bracketLevel;
            }
            current.append(c);
        }
        if (!current.isEmpty()) {
            result.add(current.toString().trim());
        }
        return result;
    }

    private static String fixResourceName(String resourceName) {
        if (resourceName.startsWith("minecraft:")) {
            return resourceName.substring("minecraft:".length());
        }
        return resourceName;
    }

    public static void loadRecipesFromLog() throws IOException {
        String name = "recipes_" + SharedConstants.getCurrentVersion().name() + ".txt";
        try (InputStream input = RecipeLoader.class.getClassLoader().getResourceAsStream(name);){
            if (input == null) {
                System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b " + name + " \u0432 \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445");
                return;
            }
            List lines = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            for (String line : lines) {
                if (!line.startsWith("Display:")) continue;
                Optional<RecipeDisplayEntry> recipeEntry = RecipeLoader.parseLineToRecipeEntry(line);
                recipeEntry.ifPresent(RecipeLoader::sendToClient);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<RecipeDisplayEntry> parseLineToRecipeEntry(String line) {
        block86: {
            try {
                Matcher categoryMatcher;
                if (line.contains("StonecutterRecipeDisplay")) {
                    Matcher categoryMatcher2;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        group = OptionalInt.of(Integer.parseInt(groupMatcher.group(1)));
                    }
                    RecipeBookCategory category = (categoryMatcher2 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (RecipeBookCategory)BuiltInRegistries.RECIPE_BOOK_CATEGORY.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)categoryMatcher2.group(1))) : RecipeBookCategories.CRAFTING_MISC;
                    Matcher inputMatcher = Pattern.compile("input=CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)]=minecraft:(.*?)\\}\\]\\]]").matcher(line);
                    if (!inputMatcher.find()) {
                        return Optional.empty();
                    }
                    String inputItem = RecipeLoader.fixResourceName(inputMatcher.group(2));
                    Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                    if (!resultMatcher.find()) {
                        return Optional.empty();
                    }
                    int resultCount = Integer.parseInt(resultMatcher.group(1));
                    String resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)]=minecraft:(.*?)\\}\\]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String stationName = RecipeLoader.fixResourceName(stationMatcher.group(2));
                    Matcher itemsMatcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!itemsMatcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = itemsMatcher.group(1);
                    ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                    for (String rawItem : itemsSection.split(";")) {
                        ArrayList<Item> arrayList = new ArrayList<Item>();
                        for (String itemVariant : rawItem.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            ResourceLocation id;
                            Item item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (Item)BuiltInRegistries.ITEM.getValue(id = ResourceLocation.fromNamespaceAndPath((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == Items.AIR) continue;
                            arrayList.add(item);
                        }
                        if (arrayList.isEmpty()) continue;
                        ingredients.add(Ingredient.of(arrayList.stream()));
                    }
                    SlotDisplay.ItemStackSlotDisplay itemSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)inputItem))));
                    SlotDisplay.Composite composite = new SlotDisplay.Composite(List.of(itemSlot));
                    SlotDisplay.ItemStackSlotDisplay resultSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)resultItem)), resultCount));
                    SlotDisplay.ItemStackSlotDisplay stationSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)stationName))));
                    RecipeDisplayId recipeDisplayId = new RecipeDisplayId(index);
                    StonecutterRecipeDisplay display = new StonecutterRecipeDisplay((SlotDisplay)composite, (SlotDisplay)resultSlot, (SlotDisplay)stationSlot);
                    RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeDisplayId, (RecipeDisplay)display, group, category, Optional.of(ingredients));
                    return Optional.of(entry);
                }
                if (line.contains("SmithingRecipeDisplay")) {
                    Pattern stackPattern;
                    Matcher matcher;
                    Matcher categoryMatcher3;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        group = OptionalInt.of(Integer.parseInt(groupMatcher.group(1)));
                    }
                    RecipeBookCategory category = (categoryMatcher3 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (RecipeBookCategory)BuiltInRegistries.RECIPE_BOOK_CATEGORY.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)categoryMatcher3.group(1))) : RecipeBookCategories.CRAFTING_MISC;
                    Matcher templateMatcher = Pattern.compile("template=CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)\\]=minecraft:(.*?)\\}\\]\\]]").matcher(line);
                    String templateItem = templateMatcher.find() ? RecipeLoader.fixResourceName(templateMatcher.group(2)) : "air";
                    String baseItem = null;
                    boolean isBaseTag = false;
                    Matcher baseMatcher = Pattern.compile("base=(?:CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:[^\\]]+\\]=minecraft:([^}\\]]+)\\}\\]\\]\\]|TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([^\\]]+)\\]\\])").matcher(line);
                    if (baseMatcher.find()) {
                        if (baseMatcher.group(1) != null) {
                            baseItem = RecipeLoader.fixResourceName(baseMatcher.group(1));
                            isBaseTag = true;
                        } else if (baseMatcher.group(2) != null) {
                            baseItem = baseMatcher.group(2);
                            isBaseTag = false;
                        }
                    }
                    if (baseItem == null) {
                        baseItem = "air";
                        isBaseTag = false;
                    }
                    String additionTag = null;
                    Matcher additionMatcher = Pattern.compile("addition=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:(.*?)\\]\\]").matcher(line);
                    if (additionMatcher.find()) {
                        if (additionMatcher.group(1) != null) {
                            additionTag = additionMatcher.group(1).contains("TagSlotDisplay") ? additionMatcher.group(1) : RecipeLoader.fixResourceName(additionMatcher.group(1));
                        } else if (additionMatcher.group(3) != null) {
                            additionTag = additionMatcher.group(3).contains("TagSlotDisplay") ? additionMatcher.group(3) : RecipeLoader.fixResourceName(additionMatcher.group(3));
                        }
                    }
                    if (additionTag == null) {
                        additionTag = "air";
                    }
                    SlotDisplay.ItemStackSlotDisplay resultSlot = null;
                    Pattern trimPattern = Pattern.compile("result=SmithingTrimSlotDisplay\\[base=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([\\w_]+)\\]\\],\\s*material=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([\\w_]+)\\]\\],\\s*pattern=(?:Reference\\{ResourceKey\\[minecraft:trim_pattern / minecraft:([\\w_]+)\\]=ArmorTrimPattern\\[assetId=minecraft:([\\w_]+),\\s*description=translation\\{key='trim_pattern\\.minecraft\\.([\\w_]+)',\\s*args=\\[\\]\\},\\s*decal=false\\]\\}\\]|CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:([\\w_]+)\\]=minecraft:[\\w_]+\\}\\]\\]\\])\\]");
                    Matcher trimResultMatcher = trimPattern.matcher(line);
                    if (trimResultMatcher.find()) {
                        String[] registries;
                        Registry trimPatterns;
                        Holder.Reference patternEntry;
                        String baseTag = trimResultMatcher.group(1);
                        String string = trimResultMatcher.group(2);
                        String patternId = trimResultMatcher.group(3);
                        TagKey baseTagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)baseTag));
                        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)string));
                        if (trimResultMatcher.group(3) != null && (patternEntry = (Holder.Reference)(trimPatterns = (registries = Minecraft.getInstance().level.registryAccess()).lookupOrThrow(Registries.TRIM_PATTERN)).get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)patternId)).orElse(null)) != null) {
                            resultSlot = new SlotDisplay.SmithingTrimDemoSlotDisplay((SlotDisplay)new SlotDisplay.TagSlotDisplay(baseTagKey), (SlotDisplay)new SlotDisplay.TagSlotDisplay(tagKey), (Holder)patternEntry);
                        }
                    }
                    if (resultSlot == null && (matcher = (stackPattern = Pattern.compile("result=StackSlotDisplay\\[stack=\\d+ minecraft:([\\w_]+)]")).matcher(line)).find()) {
                        String itemId = RecipeLoader.fixResourceName(matcher.group(1));
                        Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)itemId));
                        resultSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)item));
                    }
                    if (resultSlot == null) {
                        return Optional.empty();
                    }
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)\\]=minecraft:(.*?)\\}\\]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String string = RecipeLoader.fixResourceName(stationMatcher.group(2));
                    Matcher itemsMatcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!itemsMatcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = itemsMatcher.group(1);
                    ArrayList<Ingredient> arrayList = new ArrayList<Ingredient>();
                    for (String rawItem : itemsSection.split(";")) {
                        ArrayList<Item> alternatives = new ArrayList<Item>();
                        for (String itemVariant : rawItem.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            ResourceLocation id;
                            Item item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (Item)BuiltInRegistries.ITEM.getValue(id = ResourceLocation.fromNamespaceAndPath((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == Items.AIR) continue;
                            alternatives.add(item);
                        }
                        if (alternatives.isEmpty()) continue;
                        arrayList.add(Ingredient.of(alternatives.stream()));
                    }
                    SlotDisplay baseSlot = RecipeLoader.createSlotDisplay(baseItem, isBaseTag);
                    SlotDisplay additionSlot = RecipeLoader.createSlotDisplay(additionTag, false);
                    SlotDisplay.ItemStackSlotDisplay stationSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)string))));
                    RecipeDisplayId recipeId = new RecipeDisplayId(index);
                    SmithingRecipeDisplay display = new SmithingRecipeDisplay((SlotDisplay)new SlotDisplay.Composite(Arrays.asList(new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)templateItem)))))), baseSlot, additionSlot, (SlotDisplay)resultSlot, (SlotDisplay)stationSlot);
                    RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeId, (RecipeDisplay)display, group, category, Optional.of(arrayList));
                    return Optional.of(entry);
                }
                if (line.contains("FurnaceRecipeDisplay")) {
                    String fuelValue;
                    Matcher categoryMatcher4;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        int groupValue = Integer.parseInt(groupMatcher.group(1));
                        group = OptionalInt.of(groupValue);
                    }
                    RecipeBookCategory category = (categoryMatcher4 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (RecipeBookCategory)BuiltInRegistries.RECIPE_BOOK_CATEGORY.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)categoryMatcher4.group(1))) : RecipeBookCategories.CRAFTING_MISC;
                    SlotDisplay.TagSlotDisplay ingredientSlot = null;
                    Matcher tagMatcher = Pattern.compile("ingredient=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([\\w_]+)]]").matcher(line);
                    if (tagMatcher.find()) {
                        String tag = tagMatcher.group(1);
                        ingredientSlot = new SlotDisplay.TagSlotDisplay(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)tag)));
                    } else {
                        Matcher ingredientMatcher = Pattern.compile("ingredient=CompositeSlotDisplay\\[contents=\\[(.*?)\\]\\]").matcher(line);
                        if (!ingredientMatcher.find()) {
                            return Optional.empty();
                        }
                        String ingredientsSection = ingredientMatcher.group(1);
                        ArrayList<SlotDisplay.ItemStackSlotDisplay> ingredientSlots = new ArrayList<SlotDisplay.ItemStackSlotDisplay>();
                        Matcher itemMatcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]=]+)]=").matcher(ingredientsSection);
                        while (itemMatcher.find()) {
                            String ingredientItem = RecipeLoader.fixResourceName(itemMatcher.group(1));
                            ingredientSlots.add(new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)ingredientItem)))));
                        }
                        ingredientSlot = new SlotDisplay.Composite(ingredientSlots);
                    }
                    Matcher fuelMatcher = Pattern.compile("fuel=<([^>]+)>").matcher(line);
                    String fuel = null;
                    if (fuelMatcher.find() && !"any fuel".equals(fuelValue = fuelMatcher.group(1))) {
                        fuel = RecipeLoader.fixResourceName(fuelValue);
                    }
                    SlotDisplay.AnyFuel fuelSlot = fuel != null ? new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", fuel)))) : SlotDisplay.AnyFuel.INSTANCE;
                    Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                    if (!resultMatcher.find()) {
                        return Optional.empty();
                    }
                    int resultCount = Integer.parseInt(resultMatcher.group(1));
                    String resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String stationName = RecipeLoader.fixResourceName(stationMatcher.group(1));
                    Matcher durationMatcher = Pattern.compile("duration=(\\d+)").matcher(line);
                    int n = durationMatcher.find() ? Integer.parseInt(durationMatcher.group(1)) : 0;
                    Matcher experienceMatcher = Pattern.compile("experience=(\\d+\\.\\d+)").matcher(line);
                    float experience = experienceMatcher.find() ? Float.parseFloat(experienceMatcher.group(1)) : 0.0f;
                    Matcher matcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!matcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = matcher.group(1);
                    ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                    for (String rawItem : itemsSection.split(";")) {
                        ArrayList<Item> alternatives = new ArrayList<Item>();
                        for (String itemVariant : rawItem.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            ResourceLocation id;
                            Item item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (Item)BuiltInRegistries.ITEM.getValue(id = ResourceLocation.fromNamespaceAndPath((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == Items.AIR) continue;
                            alternatives.add(item);
                        }
                        if (alternatives.isEmpty()) continue;
                        ingredients.add(Ingredient.of(alternatives.stream()));
                    }
                    SlotDisplay.ItemStackSlotDisplay result = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)resultItem)), resultCount));
                    SlotDisplay.ItemStackSlotDisplay station = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)stationName))));
                    RecipeDisplayId recipeId = new RecipeDisplayId(index);
                    FurnaceRecipeDisplay display = new FurnaceRecipeDisplay((SlotDisplay)ingredientSlot, (SlotDisplay)fuelSlot, (SlotDisplay)result, (SlotDisplay)station, n, experience);
                    RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeId, (RecipeDisplay)display, group, category, Optional.of(ingredients));
                    return Optional.of(entry);
                }
                if (line.contains("ShapelessCraftingRecipeDisplay")) {
                    void var18_106;
                    Matcher categoryMatcher5;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index\\s*=\\s*(\\d+)\\]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        int groupValue = Integer.parseInt(groupMatcher.group(1));
                        group = OptionalInt.of(groupValue);
                    }
                    RecipeBookCategory category = (categoryMatcher5 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (RecipeBookCategory)BuiltInRegistries.RECIPE_BOOK_CATEGORY.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)categoryMatcher5.group(1))) : RecipeBookCategories.CRAFTING_MISC;
                    Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                    String resultItem = null;
                    int resultCount = 1;
                    if (!resultMatcher.find() && !(resultMatcher = Pattern.compile("result=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(\\w+)]=minecraft:(\\w+)}\\]").matcher(line)).find()) {
                        return Optional.empty();
                    }
                    if (resultMatcher.group(1) != null && resultMatcher.group(2) != null) {
                        try {
                            resultCount = Integer.parseInt(resultMatcher.group(1));
                        }
                        catch (NumberFormatException e) {
                            resultCount = 1;
                        }
                        resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    } else if (resultMatcher.group(2) != null) {
                        resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                        resultCount = 1;
                    }
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String stationName = RecipeLoader.fixResourceName(stationMatcher.group(1));
                    Matcher ingredientsMatcher = Pattern.compile("ingredients=\\[(.*)]").matcher(line);
                    if (!ingredientsMatcher.find()) {
                        return Optional.empty();
                    }
                    String ingredientsSection = ingredientsMatcher.group(1);
                    ArrayList<Object> slots = new ArrayList<Object>();
                    for (String rawSlot : RecipeLoader.splitTopLevelSlotDisplays(ingredientsSection)) {
                        Matcher itemMatcher;
                        if ((rawSlot = rawSlot.trim()).startsWith("<empty")) {
                            slots.add(SlotDisplay.Empty.INSTANCE);
                            continue;
                        }
                        if (rawSlot.startsWith("TagSlotDisplay")) {
                            String tagName = rawSlot.substring(rawSlot.indexOf("minecraft:") + "minecraft:".length(), rawSlot.indexOf("]")).trim();
                            String[] stringArray = tagName.split(":");
                            String lastWord = stringArray[stringArray.length - 1];
                            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)lastWord));
                            slots.add(new SlotDisplay.TagSlotDisplay(tagKey));
                            continue;
                        }
                        if (rawSlot.startsWith("CompositeSlotDisplay")) {
                            List<String> innerItems = RecipeLoader.extractItemSlotDisplays(rawSlot);
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            for (String nested : innerItems) {
                                Matcher matcher;
                                if ((nested = nested.trim()).startsWith("WithRemainderSlotDisplay")) {
                                    Matcher matcher2 = Pattern.compile("input=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested);
                                    Matcher remainderMatcher = Pattern.compile("remainder=StackSlotDisplay\\[stack=(\\d+) minecraft:([a-z0-9_]+)]").matcher(nested);
                                    if (!matcher2.find()) continue;
                                    String inputItemName = RecipeLoader.fixResourceName(matcher2.group(1));
                                    Item inputItem = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)inputItemName));
                                    SlotDisplay.ItemSlotDisplay input = new SlotDisplay.ItemSlotDisplay(inputItem);
                                    if (remainderMatcher.find()) {
                                        int count = Integer.parseInt(remainderMatcher.group(1));
                                        String remainderItemName = RecipeLoader.fixResourceName(remainderMatcher.group(2));
                                        Item remainderItem = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)remainderItemName));
                                        SlotDisplay.ItemStackSlotDisplay remainder = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)remainderItem, count));
                                        arrayList.add(new SlotDisplay.WithRemainder((SlotDisplay)input, (SlotDisplay)remainder));
                                        continue;
                                    }
                                    arrayList.add(input);
                                    continue;
                                }
                                if (!nested.startsWith("ItemSlotDisplay") || !(matcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested)).find()) continue;
                                String itemName = RecipeLoader.fixResourceName(matcher.group(1));
                                Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)itemName));
                                arrayList.add(new SlotDisplay.ItemSlotDisplay(item));
                            }
                            slots.add(new SlotDisplay.Composite(arrayList));
                            continue;
                        }
                        if (!rawSlot.startsWith("ItemSlotDisplay") || !(itemMatcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(rawSlot)).find()) continue;
                        String string = RecipeLoader.fixResourceName(itemMatcher.group(1));
                        Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)string));
                        slots.add(new SlotDisplay.ItemSlotDisplay(item));
                    }
                    Matcher itemsMatcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!itemsMatcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = itemsMatcher.group(1);
                    ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                    for (String string : itemsSection.split(";")) {
                        ArrayList<Item> alternatives = new ArrayList<Item>();
                        for (String itemVariant : string.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            ResourceLocation id;
                            Item item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (Item)BuiltInRegistries.ITEM.getValue(id = ResourceLocation.fromNamespaceAndPath((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == Items.AIR) continue;
                            alternatives.add(item);
                        }
                        if (alternatives.isEmpty()) continue;
                        ingredients.add(Ingredient.of(alternatives.stream()));
                    }
                    if (line.contains("result=StackSlotDisplay")) {
                        SlotDisplay.ItemStackSlotDisplay itemStackSlotDisplay = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)resultItem)), resultCount));
                    } else {
                        SlotDisplay.ItemSlotDisplay itemSlotDisplay = new SlotDisplay.ItemSlotDisplay((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)resultItem)));
                    }
                    SlotDisplay.ItemSlotDisplay station = new SlotDisplay.ItemSlotDisplay((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)stationName)));
                    RecipeDisplayId recipeId = new RecipeDisplayId(index);
                    ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = new ShapelessCraftingRecipeDisplay(slots, (SlotDisplay)var18_106, (SlotDisplay)station);
                    RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeId, (RecipeDisplay)shapelessCraftingRecipeDisplay, group, category, Optional.of(ingredients));
                    return Optional.of(entry);
                }
                if (!line.contains("ShapedCraftingRecipeDisplay")) break block86;
                Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                OptionalInt group = OptionalInt.empty();
                Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                if (groupMatcher.find()) {
                    group = OptionalInt.of(Integer.parseInt(groupMatcher.group(1)));
                }
                RecipeBookCategory category = (categoryMatcher = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (RecipeBookCategory)BuiltInRegistries.RECIPE_BOOK_CATEGORY.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)categoryMatcher.group(1))) : RecipeBookCategories.CRAFTING_MISC;
                Matcher dimMatcher = Pattern.compile("ShapedCraftingRecipeDisplay\\[width=(\\d+), height=(\\d+)").matcher(line);
                if (!dimMatcher.find()) {
                    return Optional.empty();
                }
                int width = Integer.parseInt(dimMatcher.group(1));
                int height = Integer.parseInt(dimMatcher.group(2));
                Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                String resultItem = null;
                int resultCount = 1;
                if (!resultMatcher.find() && !(resultMatcher = Pattern.compile("result=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(\\w+)]=minecraft:(\\w+)}\\]").matcher(line)).find()) {
                    return Optional.empty();
                }
                if (resultMatcher.group(1) != null && resultMatcher.group(2) != null) {
                    try {
                        resultCount = Integer.parseInt(resultMatcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        resultCount = 1;
                    }
                    resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                } else if (resultMatcher.group(2) != null) {
                    resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    resultCount = 1;
                }
                Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(line);
                if (!stationMatcher.find()) {
                    return Optional.empty();
                }
                String stationName = RecipeLoader.fixResourceName(stationMatcher.group(1));
                Matcher ingredientsMatcher = Pattern.compile("ingredients=\\[(.*)]").matcher(line);
                if (!ingredientsMatcher.find()) {
                    return Optional.empty();
                }
                String ingredientsSection = ingredientsMatcher.group(1);
                List<SlotDisplay.TagSlotDisplay> slots = new ArrayList<Object>();
                for (String rawSlot : RecipeLoader.splitTopLevelSlotDisplays(ingredientsSection)) {
                    Matcher itemMatcher;
                    if ((rawSlot = rawSlot.trim()).startsWith("<empty")) {
                        slots.add((SlotDisplay.TagSlotDisplay)SlotDisplay.Empty.INSTANCE);
                        continue;
                    }
                    if (rawSlot.startsWith("TagSlotDisplay")) {
                        String tagName = rawSlot.substring(rawSlot.indexOf("minecraft:") + "minecraft:".length(), rawSlot.indexOf("]")).trim();
                        String[] stringArray = tagName.split(":");
                        String lastWord = stringArray[stringArray.length - 1];
                        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)lastWord));
                        slots.add(new SlotDisplay.TagSlotDisplay(tagKey));
                        continue;
                    }
                    if (rawSlot.startsWith("CompositeSlotDisplay")) {
                        List<String> innerItems = RecipeLoader.extractItemSlotDisplays(rawSlot);
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        for (String nested : innerItems) {
                            Matcher itemMatcher3;
                            if ((nested = nested.trim()).startsWith("WithRemainderSlotDisplay")) {
                                Matcher inputMatcher = Pattern.compile("input=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested);
                                Matcher remainderMatcher = Pattern.compile("remainder=StackSlotDisplay\\[stack=(\\d+) minecraft:([a-z0-9_]+)]").matcher(nested);
                                if (!inputMatcher.find()) continue;
                                String inputItemName = RecipeLoader.fixResourceName(inputMatcher.group(1));
                                Item inputItem = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)inputItemName));
                                SlotDisplay.ItemSlotDisplay input = new SlotDisplay.ItemSlotDisplay(inputItem);
                                if (remainderMatcher.find()) {
                                    int count = Integer.parseInt(remainderMatcher.group(1));
                                    String remainderItemName = RecipeLoader.fixResourceName(remainderMatcher.group(2));
                                    Item remainderItem = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)remainderItemName));
                                    SlotDisplay.ItemStackSlotDisplay remainder = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)remainderItem, count));
                                    arrayList.add(new SlotDisplay.WithRemainder((SlotDisplay)input, (SlotDisplay)remainder));
                                    continue;
                                }
                                arrayList.add(input);
                                continue;
                            }
                            if (!nested.startsWith("ItemSlotDisplay") || !(itemMatcher3 = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested)).find()) continue;
                            String itemName = RecipeLoader.fixResourceName(itemMatcher3.group(1));
                            Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)itemName));
                            arrayList.add(new SlotDisplay.ItemSlotDisplay(item));
                        }
                        slots.add((SlotDisplay.TagSlotDisplay)new SlotDisplay.Composite(arrayList));
                        continue;
                    }
                    if (!rawSlot.startsWith("ItemSlotDisplay") || !(itemMatcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(rawSlot)).find()) continue;
                    String string = RecipeLoader.fixResourceName(itemMatcher.group(1));
                    Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)string));
                    slots.add((SlotDisplay.TagSlotDisplay)new SlotDisplay.ItemSlotDisplay(item));
                }
                Matcher matcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                if (!matcher.find()) {
                    return Optional.empty();
                }
                String itemsSection = matcher.group(1);
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                for (String rawItem : itemsSection.split(";")) {
                    ArrayList<Item> alternatives = new ArrayList<Item>();
                    for (String itemVariant : rawItem.split(",")) {
                        String path;
                        String[] splitItem;
                        String namespace;
                        ResourceLocation id;
                        Item item;
                        String itemName = itemVariant.trim();
                        if (itemName.isBlank() || (item = (Item)BuiltInRegistries.ITEM.getValue(id = ResourceLocation.fromNamespaceAndPath((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == Items.AIR) continue;
                        alternatives.add(item);
                    }
                    if (alternatives.isEmpty()) continue;
                    ingredients.add(Ingredient.of(alternatives.stream()));
                }
                int n = width * height;
                while (slots.size() < n) {
                    slots.add((SlotDisplay.TagSlotDisplay)new SlotDisplay.Composite(List.of()));
                }
                if (slots.size() > n) {
                    slots = slots.subList(0, n);
                }
                SlotDisplay.ItemStackSlotDisplay result = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)resultItem)), resultCount));
                SlotDisplay.ItemSlotDisplay station = new SlotDisplay.ItemSlotDisplay((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)stationName)));
                RecipeDisplayId recipeId = new RecipeDisplayId(index);
                ShapedCraftingRecipeDisplay display = new ShapedCraftingRecipeDisplay(width, height, slots, (SlotDisplay)result, (SlotDisplay)station);
                RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeId, (RecipeDisplay)display, group, category, Optional.of(ingredients));
                return Optional.of(entry);
            }
            catch (Exception e) {
                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0435 \u0441\u0442\u0440\u043e\u043a\u0438: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    private static List<String> extractItemSlotDisplays(String rawSlot) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher contentsMatcher = Pattern.compile("contents=\\[(.*)]\\]?").matcher(rawSlot);
        if (!contentsMatcher.find()) {
            return result;
        }
        String contents = contentsMatcher.group(1).trim();
        int depth = 0;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (c == '[') {
                ++depth;
            }
            if (c == ']') {
                --depth;
            }
            current.append(c);
            if ((c != ',' || depth != 0) && i != contents.length() - 1) continue;
            String part = current.toString().trim();
            if (!part.isEmpty() && !part.equals(",")) {
                result.add(part.replaceAll(",$", ""));
            }
            current.setLength(0);
        }
        return result;
    }

    private static List<String> splitTopLevelSlotDisplays(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int bracketLevel = 0;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '[') {
                ++bracketLevel;
            } else if (c == ']') {
                --bracketLevel;
            }
            if (c == ',' && bracketLevel == 0) {
                result.add(current.toString().trim());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (!current.toString().isBlank()) {
            result.add(current.toString().trim());
        }
        return result;
    }

    private static SlotDisplay createSlotDisplay(String itemOrTag, boolean isBase) {
        if (itemOrTag.equals("air")) {
            return new SlotDisplay.ItemSlotDisplay(Items.AIR);
        }
        if (isBase) {
            return new SlotDisplay.Composite(Arrays.asList(new SlotDisplay.ItemSlotDisplay((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)itemOrTag)))));
        }
        return new SlotDisplay.TagSlotDisplay(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)itemOrTag)));
    }

    static void sendToClient(RecipeDisplayEntry entry) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && minecraft.level != null) {
            ClientRecipeBook recipeBook = player.getRecipeBook();
            recipeBook.add(entry);
            recipeBook.rebuildCollections();
            SlotDisplay resultSlot = entry.display().result();
            ContextMap context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
            List resultStacks = resultSlot.resolveForStacks(context);
            if (!resultStacks.isEmpty()) {
                ItemStack result = (ItemStack)resultStacks.get(0);
                List stations = entry.display().craftingStation().resolveForStacks(context);
                if (!stations.isEmpty() && ((ItemStack)stations.get(0)).is(Items.CRAFTING_TABLE)) {
                    JebClient.existingResultItems.add(result.getItem());
                }
            }
        }
    }
}

