/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import java.util.ArrayList;
import java.util.List;
import jeb.accessor.AnimatedResultButtonExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeButton.class})
public class AnimatedResultButtonMixin
implements AnimatedResultButtonExtension {
    @Unique
    private long jeb$flashUntil = 0L;
    @Unique
    private static final Component MORE_RECIPES_TEXT = Component.translatable((String)"items.craftsfromitem");

    @Override
    @Unique
    public void jeb$flash() {
        this.jeb$flashUntil = System.currentTimeMillis() + 300L;
    }

    @Unique
    private boolean jeb$isFlashing() {
        return System.currentTimeMillis() < this.jeb$flashUntil;
    }

    @Inject(method={"renderWidget"}, at={@At(value="TAIL")})
    private void jeb$renderFlash(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.jeb$isFlashing()) {
            RecipeButton self = (RecipeButton)this;
            AnimatedResultButtonMixin.drawBorder(context, self.getX(), self.getY(), self.getWidth(), self.getHeight(), -256);
        }
    }

    private static void drawBorder(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x, y, x + width, y + 1, color);
        graphics.fill(x, y + height - 1, x + width, y + height, color);
        graphics.fill(x, y, x + 1, y + height, color);
        graphics.fill(x + width - 1, y, x + width, y + height, color);
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/recipebook/RecipeCollection;getSelectedRecipes(Lnet/minecraft/client/gui/screens/recipebook/RecipeCollection$CraftableStatus;)Ljava/util/List;"))
    private List<RecipeDisplayEntry> redirectFilter(RecipeCollection instance, RecipeCollection.CraftableStatus craftableStatus) {
        return instance.getRecipes();
    }

    @Inject(method={"getTooltipText"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetTooltip(ItemStack stack, CallbackInfoReturnable<List<Component>> cir) {
        try {
            ArrayList<Component> list = new ArrayList<Component>(Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack));
            list.add(MORE_RECIPES_TEXT);
            cir.setReturnValue(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            cir.setReturnValue(List.of(Component.literal((String)"\u00a7c[Error rendering tooltip]")));
        }
    }
}

