/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import client.JebClient;
import client.RecipeLoader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPlayNetworkHandlerMixin {
    @Inject(method={"handleRecipeBookAdd"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/ClientRecipeBook;add(Lnet/minecraft/world/item/crafting/display/RecipeDisplayEntry;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectOnRecipeBookAdd(ClientboundRecipeBookAddPacket p_379950_, CallbackInfo ci, ClientRecipeBook clientrecipebook, Iterator var3, ClientboundRecipeBookAddPacket.Entry clientboundrecipebookaddpacket$entry) {
        ContextMap context;
        SlotDisplay resultSlot = clientboundrecipebookaddpacket$entry.contents().display().result();
        List stacks = resultSlot.resolveForStacks(context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level))));
        if (stacks.isEmpty()) {
            System.err.println("Warning: Empty stacks for resultSlot in recipe " + String.valueOf(clientboundrecipebookaddpacket$entry));
            return;
        }
        ItemStack stack = (ItemStack)stacks.get(0);
        if (((ItemStack)clientboundrecipebookaddpacket$entry.contents().display().craftingStation().resolveForStacks(context).getFirst()).getItem() == Items.CRAFTING_TABLE) {
            JebClient.existingResultItems.add(stack.getItem());
        }
    }

    @Inject(method={"handleRecipeBookAdd"}, at={@At(value="TAIL")})
    private void afterRecipeBookAdd(ClientboundRecipeBookAddPacket p_379950_, CallbackInfo ci) {
        if (JebClient.recipesLoaded) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        int knownRecipeCount = 0;
        ClientRecipeBook recipeBook = null;
        int craftingStationId = 0;
        recipeBook = client.player.getRecipeBook();
        List recipes = recipeBook.getCollections();
        for (RecipeCollection collection : recipes) {
            List entries = collection.getRecipes();
            for (RecipeDisplayEntry entry : entries) {
                ContextMap context;
                SlotDisplay resultSlot = entry.display().result();
                List stacks = resultSlot.resolveForStacks(context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level))));
                ItemStack stack = (ItemStack)stacks.getFirst();
                if (stack.getItem() == Items.CRAFTING_TABLE) {
                    craftingStationId = entry.id().index();
                }
                ++knownRecipeCount;
            }
        }
        if (knownRecipeCount < 1358 && craftingStationId == 262) {
            try {
                RecipeLoader.loadRecipesFromLog();
                JebClient.recipesLoaded = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        JebClient.nonexistingResultItems.clear();
        for (Item item : BuiltInRegistries.ITEM) {
            if (item == Items.AIR || JebClient.existingResultItems.contains(item)) continue;
            JebClient.nonexistingResultItems.add(item);
        }
    }
}

