/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jeb.accessor.ClientRecipeBookAccessor;
import jeb.mixin.RecipeBookWidgetAccessor;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeBookPage.class})
public class RecipeBookResultsMixin {
    @Final
    @Shadow
    private RecipeBookComponent<?> parent;
    @Final
    @Shadow
    private OverlayRecipeComponent overlay;
    @Shadow
    private RecipeDisplayId lastClickedRecipe;
    @Shadow
    private RecipeButton hoveredButton;
    @Shadow
    @Nullable
    private RecipeCollection lastClickedRecipeCollection;

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/recipebook/RecipeButton;mouseClicked(DDI)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void onRightClickInject(double mouseX, double mouseY, int button, int x, int y, int width, int height, CallbackInfoReturnable<Boolean> cir) {
        ContextMap context = SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level);
        RecipeButton hovered = this.hoveredButton;
        if (hovered != null) {
            String searchText;
            String itemName;
            ItemStack stack;
            if (button == 2) {
                stack = hovered.getDisplayStack();
                itemName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath().toLowerCase(Locale.ROOT);
                searchText = "~" + itemName.toLowerCase(Locale.ROOT);
                ((RecipeBookWidgetAccessor)this.parent).getSearchField().setValue(searchText);
                ((RecipeBookWidgetAccessor)this.parent).setSelectedTab((RecipeBookTabButton)((RecipeBookWidgetAccessor)this.parent).getTabButtons().get(0));
                ((RecipeBookWidgetAccessor)this.parent).invokeReset();
                cir.setReturnValue((Object)true);
                cir.cancel();
            }
            if (button == 1) {
                stack = hovered.getDisplayStack();
                itemName = stack.getItem().getName().getString();
                searchText = "#" + itemName.toLowerCase(Locale.ROOT);
                ((RecipeBookWidgetAccessor)this.parent).getSearchField().setValue(searchText);
                ((RecipeBookWidgetAccessor)this.parent).setSelectedTab((RecipeBookTabButton)((RecipeBookWidgetAccessor)this.parent).getTabButtons().get(0));
                ((RecipeBookWidgetAccessor)this.parent).invokeReset();
                cir.setReturnValue((Object)true);
                cir.cancel();
            }
            if (button == 0) {
                if (!(Minecraft.getInstance().player.containerMenu instanceof AbstractCraftingMenu)) {
                    return;
                }
                Minecraft client = Minecraft.getInstance();
                ClientRecipeBook recipeBook = client.player.getRecipeBook();
                Map<RecipeDisplayId, RecipeDisplayEntry> recipes = ((ClientRecipeBookAccessor)recipeBook).getRecipes();
                RecipeDisplayEntry entry = recipes.get(hovered.getCurrentRecipe());
                if (entry != null) {
                    RecipeCollection myCustomRecipeResultCollection = new RecipeCollection(List.of(entry));
                    if (!this.canDisplay(entry.display())) {
                        this.overlay.init(myCustomRecipeResultCollection, context, false, hovered.getX(), hovered.getY(), x + width / 2, y + 13 + height / 2, (float)hovered.getWidth());
                    } else {
                        this.lastClickedRecipe = hovered.getCurrentRecipe();
                        this.lastClickedRecipeCollection = hovered.getCollection();
                        recipeBook.removeHighlight(hovered.getCurrentRecipe());
                        ClientPacketListener connection = Minecraft.getInstance().getConnection();
                        if (connection != null && hovered.getCurrentRecipe().index() != 9999) {
                            connection.send((Packet)new ServerboundRecipeBookSeenRecipePacket(hovered.getCurrentRecipe()));
                        }
                    }
                }
                cir.setReturnValue((Object)true);
                cir.cancel();
            }
        }
    }

    private boolean canDisplay(RecipeDisplay display) {
        RecipeBookComponent<?> widget = this.parent;
        AbstractCraftingMenu handler = (AbstractCraftingMenu)Minecraft.getInstance().player.containerMenu;
        int i = handler.getGridWidth();
        int j = handler.getGridHeight();
        RecipeDisplay recipeDisplay = display;
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay2, n)) {
            case 0 -> {
                ShapedCraftingRecipeDisplay shaped = (ShapedCraftingRecipeDisplay)recipeDisplay2;
                if (i >= shaped.width() && j >= shaped.height()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ShapelessCraftingRecipeDisplay shapeless = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                if (i * j >= shapeless.ingredients().size()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

