/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerRecipeBook.class})
public abstract class ServerRecipeBookMixin {
    @Shadow
    @Final
    private ServerRecipeBook.DisplayResolver displayResolver;

    @Inject(method={"sendInitialRecipeBook"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectAllRecipes(ServerPlayer player, CallbackInfo ci) {
        player.connection.send((Packet)new ClientboundRecipeBookSettingsPacket(((RecipeBook)this).getBookSettings()));
        ArrayList allEntries = new ArrayList();
        Collection allRecipes = player.getServer().getRecipeManager().getRecipes();
        for (RecipeHolder recipeEntry : allRecipes) {
            ResourceKey recipeKey = recipeEntry.id();
            Recipe recipe = recipeEntry.value();
            RecipeSerializer serializer = recipe.getSerializer();
            if (BuiltInRegistries.RECIPE_SERIALIZER.getId((Object)serializer) == -1) {
                System.out.println("[JEB Debug] Skipping unknown recipe serializer: " + serializer.getClass().getName());
                continue;
            }
            this.displayResolver.displaysForRecipe(recipeKey, display -> allEntries.add(new ClientboundRecipeBookAddPacket.Entry(display, false, false)));
        }
        player.connection.send((Packet)new ClientboundRecipeBookAddPacket(allEntries, true));
        ci.cancel();
    }
}

