/*
 * Decompiled with CFR 0.152.
 */
package jeb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jeb.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="jeb")
public class Jeb {
    public static Set<Item> existingResultItems = new HashSet<Item>();
    public static Set<Item> nonexistingResultItems = new HashSet<Item>();
    public static String search = "-";
    public static List<RecipeCollection> filtered = new ArrayList<RecipeCollection>();
    public static List<RecipeCollection> emptysearch = new ArrayList<RecipeCollection>();
    public static boolean recipesLoaded = false;
    public static boolean customToggleEnabled = true;
    public static List<RecipeCollection> PREGENERATED_RECIPES;
    public static Path CONFIG_PATH;
    private static final Gson GSON;
    public static final String MODID = "jeb";
    private static final Logger LOGGER;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<Block> EXAMPLE_BLOCK;
    public static final RegistryObject<Item> EXAMPLE_BLOCK_ITEM;
    public static final RegistryObject<Item> EXAMPLE_ITEM;
    public static final RegistryObject<CreativeModeTab> EXAMPLE_TAB;

    public static void loadConfig() {
        block8: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) break block8;
                try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json.has("customToggleEnabled")) {
                        customToggleEnabled = json.get("customToggleEnabled").getAsBoolean();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("customToggleEnabled", Boolean.valueOf(customToggleEnabled));
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<RecipeCollection> generateCustomRecipeList(String filter) {
        String query;
        ArrayList<RecipeCollection> list = new ArrayList<RecipeCollection>();
        Minecraft client = Minecraft.m_91087_();
        String modName = null;
        if (filter.startsWith("@")) {
            int endIndex = filter.indexOf(" ");
            if (endIndex != -1) {
                modName = filter.substring(1, endIndex).trim();
                query = filter.substring(endIndex + 1).toLowerCase();
            } else {
                modName = filter.substring(1).trim();
                query = "";
            }
        } else {
            query = filter.toLowerCase();
        }
        for (final Item item : nonexistingResultItems.toArray(new Item[0])) {
            if (item == Items.f_41852_) continue;
            String name = item.m_7968_().m_41611_().getString().toLowerCase(Locale.ROOT);
            String id_item = item.toString().toLowerCase(Locale.ROOT);
            String key = "";
            Component nameComponent = item.m_7968_().m_41611_();
            ComponentContents componentContents = nameComponent.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)componentContents;
                key = translatable.m_237508_().toLowerCase(Locale.ROOT);
            }
            if (modName != null && !modName.isEmpty() && !BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135827_().contains(modName.toLowerCase(Locale.ROOT))) continue;
            boolean tooltip_bool = false;
            if (client.f_91073_ != null) {
                TooltipFlag.Default tooltipFlag = client.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
                try {
                    List tooltip = item.m_7968_().m_41651_((Player)client.f_91074_, (TooltipFlag)tooltipFlag);
                    for (Component line : tooltip) {
                        String clean = ChatFormatting.m_126649_((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                        if (!clean.contains(query)) continue;
                        tooltip_bool = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!name.contains(query) && !id_item.contains(query) && !key.contains(query) && !tooltip_bool) continue;
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            CraftingRecipe recipe = new CraftingRecipe(){

                public CraftingBookCategory m_245232_() {
                    return null;
                }

                public boolean matches(CraftingContainer p_44002_, Level p_44003_) {
                    return false;
                }

                public ItemStack assemble(CraftingContainer p_44001_, RegistryAccess p_267165_) {
                    return null;
                }

                public boolean m_8004_(int p_43999_, int p_44000_) {
                    return false;
                }

                public ItemStack m_8043_(RegistryAccess p_267052_) {
                    return new ItemStack((ItemLike)item);
                }

                public ResourceLocation m_6423_() {
                    return null;
                }

                public RecipeSerializer<?> m_7707_() {
                    return null;
                }
            };
            list.add(new RecipeCollection(client.f_91073_.m_9598_(), List.of(recipe)));
        }
        return list;
    }

    public Jeb() {
        Jeb.loadConfig();
        Runtime.getRuntime().addShutdownHook(new Thread(Jeb::saveConfig));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(EXAMPLE_BLOCK_ITEM);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        recipesLoaded = false;
        search = "-";
        emptysearch.clear();
        existingResultItems.clear();
        nonexistingResultItems.clear();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        LOGGER = LogUtils.getLogger();
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
        EXAMPLE_BLOCK = BLOCKS.register("example_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_)));
        EXAMPLE_BLOCK_ITEM = ITEMS.register("example_block", () -> new BlockItem((Block)EXAMPLE_BLOCK.get(), new Item.Properties()));
        EXAMPLE_ITEM = ITEMS.register("example_item", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(1).m_38758_(2.0f).m_38767_())));
        EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> ((Item)EXAMPLE_ITEM.get()).m_7968_()).m_257501_((parameters, output) -> output.m_246326_((ItemLike)EXAMPLE_ITEM.get())).m_257652_());
    }

    @Mod.EventBusSubscriber(modid="jeb", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final String CATEGORY = "key.categories.jeb";
        public static KeyMapping FAVORITE_KEY;

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            CONFIG_PATH = Paths.get(Minecraft.m_91087_().f_91069_.getAbsolutePath(), "config", "JEB.json");
        }
    }

    @Mod.EventBusSubscriber(modid="jeb", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public class ClientEvents {
        @SubscribeEvent
        public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                PREGENERATED_RECIPES = Jeb.generateCustomRecipeList("");
            }
        }
    }

    @Mod.EventBusSubscriber(modid="jeb", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class KeybindRegistry {
        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            ClientModEvents.FAVORITE_KEY = new KeyMapping("Add/Remove Favorite Recipes", InputConstants.Type.KEYSYM, 65, "JEB (Just Enough Book)");
            event.register(ClientModEvents.FAVORITE_KEY);
        }
    }
}

