/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.RecipeBookManager;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientRecipeBook.class})
public abstract class ClientRecipeBookMixin {
    @Final
    @Shadow
    private static final Logger f_90618_ = LogUtils.getLogger();

    @Inject(method={"categorizeAndGroupRecipes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectToGroupedMap(Iterable<Recipe<?>> recipes, CallbackInfoReturnable<Map<RecipeBookCategories, List<List<Recipe<?>>>>> cir) {
        HashMap map = Maps.newHashMap();
        for (Recipe<?> recipe : recipes) {
            RecipeBookCategories recipeBookGroup = ClientRecipeBookMixin.getGroupForRecipe(recipe);
            map.computeIfAbsent(recipeBookGroup, group -> new ArrayList()).add(List.of(recipe));
        }
        cir.setReturnValue((Object)map);
    }

    @Unique
    private static RecipeBookCategories getGroupForRecipe(Recipe<?> recipe) {
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            return switch (craftingRecipe.m_245232_()) {
                case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
                case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
                case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
                case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
                default -> throw new IncompatibleClassChangeError();
            };
        }
        RecipeType recipeType = recipe.m_6671_();
        if (recipe instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe abstractCookingRecipe = (AbstractCookingRecipe)recipe;
            CookingBookCategory cookingRecipeCategory = abstractCookingRecipe.m_245534_();
            if (recipeType == RecipeType.f_44108_) {
                return switch (cookingRecipeCategory) {
                    case CookingBookCategory.BLOCKS -> RecipeBookCategories.FURNACE_BLOCKS;
                    case CookingBookCategory.FOOD -> RecipeBookCategories.FURNACE_FOOD;
                    case CookingBookCategory.MISC -> RecipeBookCategories.FURNACE_MISC;
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            if (recipeType == RecipeType.f_44109_) {
                return cookingRecipeCategory == CookingBookCategory.BLOCKS ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
            }
            if (recipeType == RecipeType.f_44110_) {
                return RecipeBookCategories.SMOKER_FOOD;
            }
            if (recipeType == RecipeType.f_44111_) {
                return RecipeBookCategories.CAMPFIRE;
            }
        }
        if (recipeType == RecipeType.f_44112_) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (recipeType == RecipeType.f_44113_) {
            return RecipeBookCategories.SMITHING;
        }
        RecipeBookCategories categories = RecipeBookManager.findCategories((RecipeType)recipeType, recipe);
        if (categories != null) {
            return categories;
        }
        f_90618_.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> BuiltInRegistries.f_256990_.m_7981_((Object)recipe.m_6671_())), LogUtils.defer(() -> recipe.m_6423_()));
        return RecipeBookCategories.UNKNOWN;
    }
}

