/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.adde0109.pcf.forwarding.Mode;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.jetbrains.annotations.ApiStatus;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={Debug.class, CrossStitch.class, Forwarding.class})
public final class PCF {
    public static final String MOD_ID = "pcf";
    public static final String CONFIG_FILE_NAME = "proxy-compatible-forge.toml";
    private static final PCF INSTANCE = new PCF();
    public static final Logger logger = Logger.create("pcf");
    private Forwarding forwarding;
    private CrossStitch crossStitch;
    private Debug debug;

    private PCF() {
    }

    public static PCF instance() {
        return INSTANCE;
    }

    @ApiStatus.Internal
    public static void forceLoadConfig() {
        try {
            if (MetaAPI.instance().isPlatformPresent(Platforms.FORGE)) {
                Class.forName("org.adde0109.pcf.v1_14_4.forge.Config").getMethod("reload", new Class[0]).invoke(null, new Object[0]);
            } else if (MetaAPI.instance().isPlatformPresent(Platforms.NEOFORGE)) {
                Class.forName("org.adde0109.pcf.v1_20_2.neoforge.Config").getMethod("reload", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to load Config class", e);
        }
    }

    public Forwarding forwarding() {
        return this.forwarding;
    }

    @ApiStatus.Internal
    public void setForwarding(Forwarding forwarding) {
        this.forwarding = forwarding;
    }

    public CrossStitch crossStitch() {
        return this.crossStitch;
    }

    @ApiStatus.Internal
    public void setCrossStitch(CrossStitch crossStitch) {
        this.crossStitch = crossStitch;
    }

    public Debug debug() {
        return this.debug;
    }

    @ApiStatus.Internal
    public void setDebug(Debug debug) {
        this.debug = debug;
    }

    @RecordComponents(value={@RecordComponents.Value(name="enabled", type=boolean.class), @RecordComponents.Value(name="mode", type=Mode.class), @RecordComponents.Value(name="secret", type=String.class)})
    @NestHost(value=PCF.class)
    public static final class Forwarding
    extends J_L_Record {
        private final boolean enabled;
        private final Mode mode;
        private final String secret;

        public Forwarding(boolean enabled, Mode mode, String secret) {
            this.enabled = enabled;
            this.mode = mode;
            this.secret = secret;
        }

        @Override
        public final String toString() {
            return Forwarding.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return Forwarding.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return Forwarding.jvmdowngrader$equals$equals(this, o);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Mode mode() {
            return this.mode;
        }

        public String secret() {
            return this.secret;
        }

        private static String jvmdowngrader$toString$toString(Forwarding forwarding) {
            Forwarding forwarding2 = forwarding;
            return "PCF$Forwarding[" + "enabled=" + forwarding.enabled + ", " + "mode=" + (Object)((Object)forwarding.mode) + ", " + "secret=" + forwarding.secret + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(Forwarding forwarding) {
            Object[] objectArray = new Object[]{forwarding.enabled, forwarding.mode, forwarding.secret};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(Forwarding forwarding, Object object) {
            if (forwarding == object) {
                return true;
            }
            if (object != null && object instanceof Forwarding) {
                Forwarding forwarding2 = (Forwarding)object;
                if (forwarding.enabled == forwarding2.enabled && Objects.equals((Object)forwarding.mode, (Object)forwarding2.mode) && Objects.equals(forwarding.secret, forwarding2.secret)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="enabled", type=boolean.class), @RecordComponents.Value(name="forceWrappedArguments", type=List.class), @RecordComponents.Value(name="forceWrapVanillaArguments", type=boolean.class)})
    @NestHost(value=PCF.class)
    public static final class CrossStitch
    extends J_L_Record {
        private final boolean enabled;
        private final List<String> forceWrappedArguments;
        private final boolean forceWrapVanillaArguments;

        public CrossStitch(boolean enabled, List<String> forceWrappedArguments, boolean forceWrapVanillaArguments) {
            this.enabled = enabled;
            this.forceWrappedArguments = forceWrappedArguments;
            this.forceWrapVanillaArguments = forceWrapVanillaArguments;
        }

        @Override
        public final String toString() {
            return CrossStitch.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return CrossStitch.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return CrossStitch.jvmdowngrader$equals$equals(this, o);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public List<String> forceWrappedArguments() {
            return this.forceWrappedArguments;
        }

        public boolean forceWrapVanillaArguments() {
            return this.forceWrapVanillaArguments;
        }

        private static String jvmdowngrader$toString$toString(CrossStitch crossStitch) {
            CrossStitch crossStitch2 = crossStitch;
            return "PCF$CrossStitch[" + "enabled=" + crossStitch.enabled + ", " + "forceWrappedArguments=" + crossStitch.forceWrappedArguments + ", " + "forceWrapVanillaArguments=" + crossStitch.forceWrapVanillaArguments + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(CrossStitch crossStitch) {
            Object[] objectArray = new Object[]{crossStitch.enabled, crossStitch.forceWrappedArguments, crossStitch.forceWrapVanillaArguments};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(CrossStitch crossStitch, Object object) {
            if (crossStitch == object) {
                return true;
            }
            if (object != null && object instanceof CrossStitch) {
                CrossStitch crossStitch2 = (CrossStitch)object;
                if (crossStitch.enabled == crossStitch2.enabled && Objects.equals(crossStitch.forceWrappedArguments, crossStitch2.forceWrappedArguments) && crossStitch.forceWrapVanillaArguments == crossStitch2.forceWrapVanillaArguments) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="enabled", type=boolean.class), @RecordComponents.Value(name="disabledMixins", type=List.class)})
    @NestHost(value=PCF.class)
    public static final class Debug
    extends J_L_Record {
        private final boolean enabled;
        private final List<String> disabledMixins;

        public Debug(boolean enabled, List<String> disabledMixins) {
            this.enabled = enabled;
            this.disabledMixins = disabledMixins;
        }

        @Override
        public final String toString() {
            return Debug.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return Debug.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return Debug.jvmdowngrader$equals$equals(this, o);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public List<String> disabledMixins() {
            return this.disabledMixins;
        }

        private static String jvmdowngrader$toString$toString(Debug debug) {
            Debug debug2 = debug;
            return "PCF$Debug[" + "enabled=" + debug.enabled + ", " + "disabledMixins=" + debug.disabledMixins + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(Debug debug) {
            Object[] objectArray = new Object[]{debug.enabled, debug.disabledMixins};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(Debug debug, Object object) {
            if (debug == object) {
                return true;
            }
            if (object != null && object instanceof Debug) {
                Debug debug2 = (Debug)object;
                if (debug.enabled == debug2.enabled && Objects.equals(debug.disabledMixins, debug2.disabledMixins)) {
                    return true;
                }
            }
            return false;
        }
    }
}

