/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta;

import java.util.Objects;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.ProtocolType;
import org.adde0109.pcf.lib.taterapi.meta.impl.version.VersionComparable;
import org.adde0109.pcf.lib.taterapi.meta.impl.version.meta.MetaStore;
import org.adde0109.pcf.lib.taterapi.meta.impl.version.meta.MinecraftVersionMetaImpl;
import org.adde0109.pcf.lib.taterapi.util.VersionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Type.class, Meta.class})
public interface MinecraftVersion
extends VersionComparable<MinecraftVersion> {
    public static MinecraftVersion of(String version) {
        return MinecraftVersions.of(version);
    }

    @ApiStatus.Internal
    default public String getPathString() {
        return MinecraftVersion.jvmdowngrader$concat$getPathString$1(this.toString().replace(".", "_"));
    }

    @ApiStatus.Experimental
    default public Meta meta() {
        return MetaStore.getMeta(this);
    }

    @Override
    default public boolean parseRange(@NotNull String rangeString) {
        Objects.requireNonNull(rangeString, "Range string cannot be null");
         @Nullable VersionUtil.Range range = VersionUtil.Range.parse(rangeString);
        if (range == null) {
            return this.is(rangeString);
        }
        MinecraftVersion start = range.start() == null ? MinecraftVersions.UNKNOWN : MinecraftVersions.of(range.start());
        MinecraftVersion end = range.end() == null ? MinecraftVersions.UNKNOWN : MinecraftVersions.of(range.end());
        return this.isInRange(range.startInclusive(), start, range.endInclusive(), end);
    }

    private static String jvmdowngrader$concat$getPathString$1(String string) {
        return "v" + string;
    }

    @NestHost(value=MinecraftVersion.class)
    @ApiStatus.Experimental
    public static interface Meta {
        public static final Meta UNKNOWN = new MinecraftVersionMetaImpl(new Integer[]{0, 0, 0, 0, 0, 0});

        public int protocol();

        public ProtocolType protocolType();

        public Type type();

        public int dataVersion();

        public int resourcePackFormat();

        public int dataPackFormat();
    }

    @NestHost(value=MinecraftVersion.class)
    public static enum Type {
        UNKNOWN,
        SNAPSHOT,
        EXP_SNAPSHOT,
        PRE_RELEASE,
        RELEASE_CANDIDATE,
        RELEASE;


        public static Type fromInt(int i) {
            Type type;
            switch (i) {
                case 1: {
                    type = SNAPSHOT;
                    break;
                }
                case 2: {
                    type = EXP_SNAPSHOT;
                    break;
                }
                case 3: {
                    type = PRE_RELEASE;
                    break;
                }
                case 4: {
                    type = RELEASE_CANDIDATE;
                    break;
                }
                case 5: {
                    type = RELEASE;
                    break;
                }
                default: {
                    type = UNKNOWN;
                }
            }
            return type;
        }
    }
}

