/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.SystemLogger;
import org.adde0109.pcf.lib.taterapi.meta.Mappings;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.BungeeCordMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.FabricMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.IgniteMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.NeoForgeMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.VanillaMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.VelocityMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.bukkit.BukkitMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge.ForgeData;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.sponge.SpongeData;
import org.adde0109.pcf.lib.taterapi.reflecto.MappingEntry;
import org.adde0109.pcf.lib.taterapi.reflecto.Reflecto;
import org.adde0109.pcf.lib.taterapi.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public final class MetaAPIImpl
implements MetaAPI {
    private static MetaAPIImpl INSTANCE;
    private static Mappings mappings;
    static Reflecto.MappingStore store;
    private Platform primaryPlatform;

    public static MetaAPIImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaAPIImpl();
        }
        return INSTANCE;
    }

    private MetaAPIImpl() {
    }

    private void initReflection() {
        if (!(Platforms.get().isEmpty() || this.isProxy() || this.isPlatformPresent(Platforms.BUKKIT))) {
            store = Reflecto.instance().getStore(this);
            if (this.isClient()) {
                MappingEntry.Builder minecraft = MappingEntry.builder("Minecraft").official("net.minecraft.client.Minecraft").mojang("net.minecraft.client.Minecraft").searge("net.minecraft.client.Minecraft").legacySearge("net.minecraft.client.Minecraft").mcp("net.minecraft.client.Minecraft").yarnIntermediary("net.minecraft.class_310").legacyIntermediary("net.minecraft.class_1600");
                MappingEntry.Builder minecraft_getInstance = MappingEntry.builder("getInstance").parentEntry(minecraft).mojang("getInstance").searge("m_91087_").legacySearge("func_71410_x").mcp("getInstance").mcp("getMinecraft", MinecraftVersions.UNKNOWN, MinecraftVersions.V12_2).yarnIntermediary("method_1551").legacyIntermediary("method_2965");
                MappingEntry.Builder minecraft_hasServer = MappingEntry.builder("hasServer").parentEntry(minecraft).mojang("hasSingleplayerServer").searge("m_91091_").legacySearge("func_71356_B").mcp("isSingleplayer").yarnIntermediary("method_1496").legacyIntermediary("method_2908");
                MappingEntry.Builder minecraft_getServer = MappingEntry.builder("getServer").parentEntry(minecraft).official("getSingleplayerServer").mojang("getSingleplayerServer").searge("m_91092_").legacySearge("func_71401_C").mcp("getIntegratedServer").yarnIntermediary("method_1576").legacyIntermediary("method_2909");
                store.registerClass(minecraft).registerMethod(minecraft_getInstance, new Class[0]).registerMethod(minecraft_hasServer, new Class[0]).registerMethod(minecraft_getServer, new Class[0]);
            }
            Logger logger = Logger.create("MetaAPI");
            logger.debug("Registered Minecraft reflection mappings");
            logger.debug("|-> getInstance");
            logger.debug("|-> hasServer");
            logger.debug("|-> getServer");
            String mcString = "net.minecraft.server.MinecraftServer";
            MappingEntry.Builder mcServer = MappingEntry.builder("MinecraftServer").official(mcString).mojang(mcString).spigot(mcString).legacySpigot(mcString).searge(mcString).searge(mcString).legacySearge(mcString).mcp(mcString).yarnIntermediary(mcString).legacyIntermediary(mcString);
            MappingEntry.Builder mcServer_isDedicatedServer = MappingEntry.builder("isDedicatedServer").parentEntry(mcServer).mojang("isDedicatedServer").searge("m_6982_").legacySearge("func_71262_S").mcp("isDedicatedServer").yarnIntermediary("method_3816").legacyIntermediary("method_2983");
            store.registerClass(mcServer).registerMethod(mcServer_isDedicatedServer, new Class[0]);
            logger.debug("Registered MinecraftServer reflection mappings");
            logger.debug("|-> isDedicatedServer");
        }
    }

    @Override
    @NotNull
    public Platform primaryPlatform() throws MetaAPI.NoPrimaryPlatformException {
        if (this.primaryPlatform == null) {
            throw new MetaAPI.NoPrimaryPlatformException();
        }
        return this.primaryPlatform;
    }

    @Override
    public void setPrimaryPlatform(@NotNull Platform platform) throws MetaAPI.RedefinePrimaryPlatformException, NullPointerException {
        Objects.requireNonNull(platform, "Platform cannot be null");
        if (this.primaryPlatform != null && !this.primaryPlatform.equals(platform)) {
            throw new MetaAPI.RedefinePrimaryPlatformException();
        }
        this.primaryPlatform = platform;
    }

    @Override
    public boolean isPrimaryPlatform(@NotNull Platform platform) throws MetaAPI.NoPrimaryPlatformException, NullPointerException {
        Objects.requireNonNull(platform, "Platform cannot be null");
        return this.primaryPlatform() == platform;
    }

    @Override
    @NotNull
    public Platform platform() throws MetaAPI.NoPlatformException {
        if (this.primaryPlatform == null) {
            return (Platform)Platforms.get().stream().findFirst().orElseThrow(MetaAPI.NoPlatformException::new);
        }
        return this.primaryPlatform;
    }

    @Override
    public boolean isPlatformPresent(@NotNull Platform platform) throws NullPointerException {
        Objects.requireNonNull(platform, "Platform cannot be null");
        return Platforms.get().contains(platform);
    }

    @Override
    @NotNull
    public Platform.Meta meta() throws MetaAPI.NoPlatformException, MetaAPI.NoPlatformMetaException {
        return MetaAPIImpl.lookup(this.platform()).orElseThrow(() -> new MetaAPI.NoPlatformMetaException(this.platform()));
    }

    @Override
    public Optional<Platform.Meta> meta(@NotNull Platform platform) throws NullPointerException {
        Objects.requireNonNull(platform, "Platform cannot be null");
        return MetaAPIImpl.lookup(platform);
    }

    @Override
    @NotNull
    public Object server() {
        if (store == null) {
            this.initReflection();
        }
        return MetaAPIImpl.lookupAll().stream().map(Platform.Meta::server).findFirst().orElseThrow(NullPointerException::new);
    }

    @Override
    @NotNull
    public Object client() {
        if (store == null) {
            this.initReflection();
        }
        return MetaAPIImpl.lookupAll().stream().map(Platform.Meta::client).findFirst().orElseThrow(NullPointerException::new);
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (store == null) {
            this.initReflection();
        }
        return MetaAPIImpl.lookupAll().stream().map(Platform.Meta::minecraft).findFirst().orElseThrow(NullPointerException::new);
    }

    @Override
    @NotNull
    public Side side() {
        if (store == null) {
            this.initReflection();
        }
        return MetaAPIImpl.lookupAll().stream().map(Platform.Meta::side).findFirst().orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean isClient() {
        return MetaAPIImpl.lookupAll().stream().anyMatch(Platform.Meta::isClient);
    }

    @Override
    @NotNull
    public MinecraftVersion version() {
        return MetaAPIImpl.lookupAll().stream().map(Platform.Meta::minecraftVersion).findFirst().orElse(MinecraftVersions.UNKNOWN);
    }

    @Override
    public boolean isModLoaded(String ... nameOrId) throws NullPointerException {
        Objects.requireNonNull(nameOrId, "Name or ID cannot be null");
        return MetaAPIImpl.lookupAll().stream().anyMatch(meta -> meta.isModLoaded(nameOrId));
    }

    @Override
    public boolean isModLoaded(@NotNull Platform platform, String ... nameOrId) throws NullPointerException {
        Objects.requireNonNull(platform, "Platform cannot be null");
        Objects.requireNonNull(nameOrId, "Name or ID cannot be null");
        return MetaAPIImpl.lookup(platform).map(meta -> meta.isModLoaded(nameOrId)).orElse(false);
    }

    @Override
    public boolean areModsLoaded(String ... nameOrId) throws NullPointerException {
        Objects.requireNonNull(nameOrId, "Name or ID cannot be null");
        return MetaAPIImpl.lookupAll().stream().allMatch(meta -> meta.isModLoaded(nameOrId));
    }

    @Override
    public boolean areModsLoaded(@NotNull Platform platform, String ... nameOrId) throws NullPointerException {
        Objects.requireNonNull(platform, "Platform cannot be null");
        Objects.requireNonNull(nameOrId, "Name or ID cannot be null");
        return MetaAPIImpl.lookup(platform).map(meta -> meta.isModLoaded(nameOrId)).orElse(false);
    }

    @Override
    @NotNull
    public Mappings mappings() {
        if (mappings == null) {
            MetaAPI api = MetaAPI.instance();
            if (api.isProxy()) {
                mappings = Mappings.NONE;
            } else if (api.isMixedForgeFabric()) {
                if (api.isModLoaded(Platforms.FABRIC, "kilt")) {
                    mappings = Mappings.YARN_INTERMEDIARY;
                } else if (api.isModLoaded(Platforms.FORGE, "fabric_api", "connector")) {
                    mappings = Mappings.SEARGE;
                }
            } else {
                mappings = api.isMixedNeoForgeFabric() && api.isModLoaded(Platforms.NEOFORGE, "fabric_api", "connector") ? Mappings.MOJANG : (api.isPlatformPresent(Platforms.NEOFORGE) ? (this.version().is(MinecraftVersions.V20_1) ? Mappings.SEARGE : Mappings.MOJANG) : (api.isPlatformPresent(Platforms.FORGE) ? (this.version().isAtMost(MinecraftVersions.V16_5) ? Mappings.LEGACY_SEARGE : (this.version().isInRange(MinecraftVersions.V17, MinecraftVersions.V20_5) ? Mappings.SEARGE : Mappings.MOJANG)) : (api.isPlatformPresent(Platforms.FABRIC) ? (this.version().isOlderThan(MinecraftVersions.V14) ? Mappings.LEGACY_INTERMEDIARY : Mappings.YARN_INTERMEDIARY) : (api.isPlatformPresent(Platforms.SPONGE) ? (this.version().isOlderThan(MinecraftVersions.V14) ? Mappings.SEARGE : Mappings.MOJANG) : (api.isPlatformPresent(Platforms.PAPER) && this.version().isAtLeast(MinecraftVersions.V20_5) ? Mappings.MOJANG : (api.isPlatformPresent(Platforms.SPIGOT) ? (this.version().isOlderThan(MinecraftVersions.V18) ? Mappings.LEGACY_SPIGOT : Mappings.SPIGOT) : (api.isPlatformPresent(Platforms.BUKKIT) ? Mappings.OFFICIAL : Mappings.OFFICIAL)))))));
            }
        }
        return Objects.requireNonNull(mappings, "Mappings are null after initialization");
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) throws NullPointerException {
        Objects.requireNonNull(modId, "Mod ID cannot be null");
        return MetaAPIImpl.lookupAll().stream().map(meta -> meta.logger(modId)).findFirst().orElse(new SystemLogger(modId));
    }

    public static Optional<Platform.Meta> lookup(Platform platform) {
        if (MetaAPI.isNeoForgeBased(platform)) {
            return Optional.of(new NeoForgeMeta());
        }
        if (MetaAPI.isForgeBased(platform)) {
            return Optional.ofNullable(ForgeData.create());
        }
        if (MetaAPI.isFabricBased(platform)) {
            return Optional.of(new FabricMeta());
        }
        if (platform == Platforms.SPONGE) {
            return Optional.ofNullable(SpongeData.create());
        }
        if (MetaAPI.isBukkitBased(platform)) {
            return Optional.of(new BukkitMeta());
        }
        if (MetaAPI.isBungeeCordBased(platform)) {
            return Optional.of(new BungeeCordMeta());
        }
        if (platform == Platforms.VELOCITY) {
            return Optional.of(new VelocityMeta());
        }
        if (platform == Platforms.IGNITE) {
            return Optional.of(new IgniteMeta());
        }
        if (ReflectionUtil.checkForClass("org.spongepowered.asm.service.MixinService")) {
            return Optional.of(new VanillaMeta());
        }
        return Optional.empty();
    }

    public static List<Platform.Meta> lookupAll() {
        return J_U_S_Stream.toList(Platforms.get().stream().map(MetaAPIImpl::lookup).filter(Optional::isPresent).map(Optional::get));
    }
}

