/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.ApacheLogger;
import org.adde0109.pcf.lib.taterapi.logger.impl.Slf4jLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.jetbrains.annotations.NotNull;

public final class FabricMeta
implements Platform.Meta {
    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return this.minecraft();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        return FabricLoader.getInstance().getGameInstance();
    }

    @Override
    @NotNull
    public Side side() {
        return WMinecraft.determineSide(this.isClient());
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return MinecraftVersion.of(((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString());
    }

    @Override
    @NotNull
    public String loaderVersion() {
        Optional container = FabricLoader.getInstance().getModContainer("fabric-loader");
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString();
        }
        return "Unknown";
    }

    @Override
    @NotNull
    public String apiVersion() {
        Optional container = FabricLoader.getInstance().getModContainer("fabric-api-base");
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString();
        }
        return "Unknown";
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return FabricLoader.getInstance().getAllMods().stream().map(modContainer -> new ModInfoImpl(modContainer.getMetadata().getId(), modContainer.getMetadata().getName(), modContainer.getMetadata().getVersion().getFriendlyString(), Platforms.FABRIC)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        MinecraftVersion version = this.minecraftVersion();
        if (version.isOlderThan(MinecraftVersions.V18)) {
            return new ApacheLogger(modId);
        }
        return new Slf4jLogger(modId);
    }
}

