/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.SystemLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraftServer;
import org.adde0109.pcf.lib.taterapi.util.MixinServiceUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class VanillaMeta
implements Platform.Meta {
    private static Object server = null;

    @ApiStatus.Internal
    public static void setServer(Object server) {
        VanillaMeta.server = server;
    }

    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return this.minecraft();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        if (server == null) {
            throw new IllegalStateException("Server has not been set");
        }
        return server;
    }

    @Override
    @NotNull
    public Side side() {
        if (server == null) {
            return Side.CLIENT;
        }
        return WMinecraftServer.isDedicatedServer(server) ? Side.INTEGRATED : Side.SERVER;
    }

    @Override
    public boolean isClient() {
        return this.side().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        String version = "Unknown";
        try {
            version = MixinServiceUtil.mcVersion();
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return MinecraftVersion.of(version);
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return this.minecraftVersion().toString();
    }

    @Override
    @NotNull
    public String apiVersion() {
        return this.minecraftVersion().toString();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new SystemLogger(modId);
    }
}

