/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.bukkit;

import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.FabricMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.NeoForgeMeta;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge.ForgeData;
import org.jetbrains.annotations.NotNull;

final class BukkitHybridMeta {
    private BukkitHybridMeta() {
    }

    @NotNull
    static MinecraftVersion minecraftVersion() {
        if (MetaAPI.instance().isPlatformPresent(Platforms.FORGE)) {
            Platform.Meta forge = ForgeData.create();
            if (forge != null) {
                return forge.minecraftVersion();
            }
        } else {
            if (MetaAPI.instance().isPlatformPresent(Platforms.NEOFORGE)) {
                NeoForgeMeta neoForge = new NeoForgeMeta();
                return neoForge.minecraftVersion();
            }
            if (MetaAPI.instance().isPlatformPresent(Platforms.FABRIC)) {
                FabricMeta fabric = new FabricMeta();
                return fabric.minecraftVersion();
            }
        }
        throw new IllegalStateException("No hybrid platform detected");
    }

    @NotNull
    static Logger logger(@NotNull String modId) {
        if (MetaAPI.instance().isPlatformPresent(Platforms.FORGE)) {
            Platform.Meta forge = ForgeData.create();
            if (forge != null) {
                return forge.logger(modId);
            }
        } else {
            if (MetaAPI.instance().isPlatformPresent(Platforms.NEOFORGE)) {
                NeoForgeMeta neoForge = new NeoForgeMeta();
                return neoForge.logger(modId);
            }
            if (MetaAPI.instance().isPlatformPresent(Platforms.FABRIC)) {
                FabricMeta fabric = new FabricMeta();
                return fabric.logger(modId);
            }
        }
        throw new IllegalStateException("No hybrid platform detected");
    }
}

