/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.sponge;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.Slf4jLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraftServer;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;

final class SpongeLegacyMeta
implements Platform.Meta {
    SpongeLegacyMeta() {
    }

    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return Sponge.getServer();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        return this.server();
    }

    @Override
    @NotNull
    public Side side() {
        if (Sponge.getServer() == null) {
            return Side.CLIENT;
        }
        return WMinecraftServer.isDedicatedServer(Sponge.getServer()) ? Side.INTEGRATED : Side.SERVER;
    }

    @Override
    public boolean isClient() {
        return this.side().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return MinecraftVersion.of(Sponge.getPlatform().getMinecraftVersion().getName());
    }

    @Override
    @NotNull
    public String loaderVersion() {
        Optional container = Sponge.getPluginManager().getPlugin("sponge");
        if (container.isPresent()) {
            return ((PluginContainer)container.get()).getVersion().toString();
        }
        return "Unknown";
    }

    @Override
    @NotNull
    public String apiVersion() {
        Optional container = Sponge.getPluginManager().getPlugin("sponge-api");
        if (container.isPresent()) {
            return ((PluginContainer)container.get()).getVersion().toString();
        }
        return "Unknown";
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return Sponge.getPluginManager().getPlugins().stream().map(pluginContainer -> new ModInfoImpl(pluginContainer.getId(), pluginContainer.getName(), pluginContainer.getVersion().orElse("Unknown"), Platforms.SPONGE)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new Slf4jLogger(modId);
    }
}

