/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.version;

import java.util.Objects;
import org.adde0109.pcf.lib.taterapi.util.FlexVerComparator;
import org.jetbrains.annotations.NotNull;

public interface VersionComparable<T extends VersionComparable<?>>
extends Comparable<T> {
    public String version();

    @Override
    default public int compareTo(@NotNull T o) {
        Objects.requireNonNull(o, "version cannot be null");
        return FlexVerComparator.compare(this.version(), o.version());
    }

    default public boolean is(@NotNull String version) {
        Objects.requireNonNull(version, "version cannot be null");
        return FlexVerComparator.compare(this.version(), version) == 0;
    }

    default public boolean is(@NotNull T version) {
        Objects.requireNonNull(version, "version cannot be null");
        return this.compareTo(version) == 0;
    }

    default public boolean isInRange(boolean startInclusive, @NotNull String start, boolean endInclusive, @NotNull String end) {
        Objects.requireNonNull(start, "start cannot be null");
        Objects.requireNonNull(end, "end cannot be null");
        int compareStart = FlexVerComparator.compare(this.version(), start);
        int compareEnd = FlexVerComparator.compare(this.version(), end);
        if (start.equals("unknown")) {
            compareStart = 1;
        }
        if (end.equals("unknown")) {
            compareEnd = -1;
        }
        return (startInclusive ? compareStart >= 0 : compareStart > 0) && (endInclusive ? compareEnd <= 0 : compareEnd < 0);
    }

    default public boolean isInRange(boolean startInclusive, @NotNull T start, boolean endInclusive, @NotNull T end) {
        Objects.requireNonNull(start, "start cannot be null");
        Objects.requireNonNull(end, "end cannot be null");
        int compareStart = FlexVerComparator.compare(this.version(), start.version());
        int compareEnd = FlexVerComparator.compare(this.version(), end.version());
        if (start.version().equals("unknown")) {
            compareStart = 1;
        }
        if (end.version().equals("unknown")) {
            compareEnd = -1;
        }
        return (startInclusive ? compareStart >= 0 : compareStart > 0) && (endInclusive ? compareEnd <= 0 : compareEnd < 0);
    }

    default public boolean isInRange(@NotNull String start, @NotNull String end) {
        Objects.requireNonNull(start, "start cannot be null");
        Objects.requireNonNull(end, "end cannot be null");
        int compareStart = FlexVerComparator.compare(this.version(), start);
        int compareEnd = FlexVerComparator.compare(this.version(), end);
        if (start.equals("unknown")) {
            compareStart = 1;
        }
        if (end.equals("unknown")) {
            compareEnd = -1;
        }
        return compareStart >= 0 && compareEnd <= 0;
    }

    default public boolean isInRange(@NotNull T start, @NotNull T end) {
        Objects.requireNonNull(start, "start cannot be null");
        Objects.requireNonNull(end, "end cannot be null");
        int compareStart = FlexVerComparator.compare(this.version(), start.version());
        int compareEnd = FlexVerComparator.compare(this.version(), end.version());
        if (start.version().equals("unknown")) {
            compareStart = 1;
        }
        if (end.version().equals("unknown")) {
            compareEnd = -1;
        }
        return compareStart >= 0 && compareEnd <= 0;
    }

    public boolean parseRange(@NotNull String var1);

    default public boolean isNewerThan(@NotNull String version) {
        Objects.requireNonNull(version, "version cannot be null");
        return FlexVerComparator.compare(this.version(), version) > 0;
    }

    default public boolean isNewerThan(@NotNull T version) {
        Objects.requireNonNull(version, "version cannot be null");
        return this.compareTo(version) > 0;
    }

    default public boolean isAtLeast(@NotNull String version) {
        Objects.requireNonNull(version, "version cannot be null");
        return FlexVerComparator.compare(this.version(), version) >= 0;
    }

    default public boolean isAtLeast(@NotNull T version) {
        Objects.requireNonNull(version, "version cannot be null");
        return this.compareTo(version) >= 0;
    }

    default public boolean isOlderThan(@NotNull String version) {
        Objects.requireNonNull(version, "version cannot be null");
        return FlexVerComparator.compare(this.version(), version) < 0;
    }

    default public boolean isOlderThan(@NotNull T version) {
        Objects.requireNonNull(version, "version cannot be null");
        return this.compareTo(version) < 0;
    }

    default public boolean isAtMost(@NotNull String version) {
        Objects.requireNonNull(version, "version cannot be null");
        return FlexVerComparator.compare(this.version(), version) <= 0;
    }

    default public boolean isAtMost(@NotNull T version) {
        Objects.requireNonNull(version, "version cannot be null");
        return this.compareTo(version) <= 0;
    }
}

