/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.muxins;

import java.util.List;
import org.adde0109.pcf.lib.taterapi.meta.Mappings;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.enums.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.enums.Platform;
import org.adde0109.pcf.lib.taterapi.muxins.Muxins;
import org.adde0109.pcf.lib.taterapi.muxins.annotations.ReqDependency;
import org.adde0109.pcf.lib.taterapi.muxins.annotations.ReqMCVersion;
import org.adde0109.pcf.lib.taterapi.muxins.annotations.ReqMappings;
import org.adde0109.pcf.lib.taterapi.muxins.annotations.ReqPlatform;
import org.adde0109.pcf.lib.taterapi.util.TextUtil;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;

public final class AnnotationChecker {
    private static final Platform.Meta meta = MetaAPI.instance().meta();
    private static final org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion minecraftVersion = MetaAPI.instance().version();
    private static final Mappings mappings = MetaAPI.instance().mappings();

    private AnnotationChecker() {
    }

    public static boolean checkAnnotations(List<AnnotationNode> annotations, String mixinClassName, boolean verbose) {
        for (AnnotationNode node : annotations) {
            if (!(Type.getDescriptor(ReqDependency.class).equals(node.desc) ? !AnnotationChecker.checkReqDependency(mixinClassName, node, verbose) : (Type.getDescriptor(ReqMappings.class).equals(node.desc) ? !AnnotationChecker.checkReqMappings(mixinClassName, node, verbose) : (Type.getDescriptor(ReqPlatform.class).equals(node.desc) ? !AnnotationChecker.checkReqPlatform(mixinClassName, node, verbose) : Type.getDescriptor(ReqMCVersion.class).equals(node.desc) && !AnnotationChecker.checkReqMCVersion(mixinClassName, node, verbose))))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkReqDependency(String mixinClassName, AnnotationNode annotation, boolean verbose) {
        List reqDependency = Annotations.getValue((AnnotationNode)annotation, (String)"value", (boolean)true);
        if (!reqDependency.isEmpty()) {
            for (String dep : reqDependency) {
                if (dep.startsWith("!")) {
                    String dependency = dep.substring(1);
                    if (!meta.isModLoaded(dependency)) continue;
                    if (verbose) {
                        Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqDependency$1(mixinClassName, dependency)));
                    }
                    return false;
                }
                if (meta.isModLoaded(dep)) continue;
                if (verbose) {
                    Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqDependency$2(mixinClassName, dep)));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean checkReqMappings(String mixinClassName, AnnotationNode annotation, boolean verbose) {
        Mappings mixinMappings = (Mappings)Annotations.getValue((AnnotationNode)annotation, (String)"value", Mappings.class, (Enum)Mappings.NONE);
        if (mixinMappings != Mappings.NONE && !mappings.is(mixinMappings)) {
            if (verbose) {
                Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqMappings$1(mixinClassName)));
            }
            return false;
        }
        return true;
    }

    public static boolean checkReqPlatform(String mixinClassName, AnnotationNode annotation, boolean verbose) {
        List notPlatforms;
        List platforms = Annotations.getValue((AnnotationNode)annotation, (String)"value", (boolean)true, Platform.class);
        if (!platforms.isEmpty()) {
            for (Platform plat : platforms) {
                if (MetaAPI.instance().isPlatformPresent(plat.ref())) continue;
                if (verbose) {
                    Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqPlatform$1(mixinClassName)));
                }
                return false;
            }
        }
        if (!(notPlatforms = Annotations.getValue((AnnotationNode)annotation, (String)"not", (boolean)true, Platform.class)).isEmpty()) {
            for (Platform plat : notPlatforms) {
                if (!MetaAPI.instance().isPlatformPresent(plat.ref())) continue;
                if (verbose) {
                    Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqPlatform$2(mixinClassName)));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean checkReqMCVersion(String mixinClassName, AnnotationNode annotation, boolean verbose) {
        List versions;
        MinecraftVersion min = (MinecraftVersion)Annotations.getValue((AnnotationNode)annotation, (String)"min", MinecraftVersion.class, (Enum)MinecraftVersion.UNKNOWN);
        MinecraftVersion max = (MinecraftVersion)Annotations.getValue((AnnotationNode)annotation, (String)"max", MinecraftVersion.class, (Enum)MinecraftVersion.UNKNOWN);
        if (min != MinecraftVersion.UNKNOWN || max != MinecraftVersion.UNKNOWN) {
            if (min != null && !minecraftVersion.isAtLeast(min.ref())) {
                if (verbose) {
                    Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqMCVersion$1(mixinClassName)));
                }
                return false;
            }
            if (max != null && !minecraftVersion.isAtMost(max.ref())) {
                if (verbose) {
                    Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqMCVersion$2(mixinClassName)));
                }
                return false;
            }
        }
        if (!(versions = Annotations.getValue((AnnotationNode)annotation, (String)"value", (boolean)true, MinecraftVersion.class)).isEmpty()) {
            for (MinecraftVersion version : versions) {
                if (!minecraftVersion.is(version.ref())) continue;
                return true;
            }
            if (verbose) {
                Muxins.logger.info(TextUtil.ansiParser(AnnotationChecker.jvmdowngrader$concat$checkReqMCVersion$3(mixinClassName)));
            }
            return false;
        }
        return true;
    }

    private static String jvmdowngrader$concat$checkReqDependency$1(String string, String string2) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74conflicts with dependency: \u00a79" + string2;
    }

    private static String jvmdowngrader$concat$checkReqDependency$2(String string, String string2) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74missing dependency: \u00a79" + string2;
    }

    private static String jvmdowngrader$concat$checkReqMappings$1(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74mappings not supported";
    }

    private static String jvmdowngrader$concat$checkReqPlatform$1(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74no supported platform detected";
    }

    private static String jvmdowngrader$concat$checkReqPlatform$2(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74platform not supported";
    }

    private static String jvmdowngrader$concat$checkReqMCVersion$1(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74Minecraft version is too old";
    }

    private static String jvmdowngrader$concat$checkReqMCVersion$2(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74Minecraft version is too recent";
    }

    private static String jvmdowngrader$concat$checkReqMCVersion$3(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74Minecraft version not supported";
    }
}

